/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class BeanMap
extends AbstractMap<String, Object>
implements Cloneable {
    public static final Object[] NULL_ARGUMENTS = new Object[0];
    private static final Map<Class<? extends Object>, Function<?, ?>> typeTransformers = Collections.unmodifiableMap(BeanMap.createTypeTransformers());
    private transient Object bean;
    private final transient HashMap<String, Method> readMethods = new HashMap();
    private final transient HashMap<String, Method> writeMethods = new HashMap();
    private final transient HashMap<String, Class<? extends Object>> types = new HashMap();

    private static Map<Class<? extends Object>, Function<?, ?>> createTypeTransformers() {
        HashMap defTransformers = new HashMap();
        defTransformers.put(Boolean.TYPE, input -> Boolean.valueOf(input.toString()));
        defTransformers.put(Character.TYPE, input -> Character.valueOf(input.toString().charAt(0)));
        defTransformers.put(Byte.TYPE, input -> Byte.valueOf(input.toString()));
        defTransformers.put(Short.TYPE, input -> Short.valueOf(input.toString()));
        defTransformers.put(Integer.TYPE, input -> Integer.valueOf(input.toString()));
        defTransformers.put(Long.TYPE, input -> Long.valueOf(input.toString()));
        defTransformers.put(Float.TYPE, input -> Float.valueOf(input.toString()));
        defTransformers.put(Double.TYPE, input -> Double.valueOf(input.toString()));
        return defTransformers;
    }

    public BeanMap() {
    }

    public BeanMap(Object bean) {
        this.bean = bean;
        this.initialize();
    }

    @Override
    public void clear() {
        if (this.bean == null) {
            return;
        }
        Class<?> beanClass = null;
        try {
            beanClass = this.bean.getClass();
            this.bean = beanClass.newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not create new instance of class: " + beanClass, e);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BeanMap newMap = (BeanMap)super.clone();
        if (this.bean == null) {
            return newMap;
        }
        Object newBean = null;
        Class<?> beanClass = this.bean.getClass();
        try {
            newBean = beanClass.newInstance();
        }
        catch (Exception e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException("Unable to instantiate the underlying bean \"" + beanClass.getName() + "\": " + e);
            cnse.initCause(e);
            throw cnse;
        }
        try {
            newMap.setBean(newBean);
        }
        catch (Exception e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException("Unable to set bean in the cloned bean map: " + e);
            cnse.initCause(e);
            throw cnse;
        }
        try {
            this.readMethods.keySet().forEach((? super T key) -> {
                if (this.getWriteMethod((String)key) != null) {
                    newMap.put((String)key, this.get(key));
                }
            });
        }
        catch (Exception e) {
            CloneNotSupportedException cnse = new CloneNotSupportedException("Unable to copy bean values to cloned bean map: " + e);
            cnse.initCause(e);
            throw cnse;
        }
        return newMap;
    }

    @Override
    public boolean containsKey(Object name) {
        Method method = this.getReadMethod(name);
        return method != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    protected <R> Object convertType(Class<R> newType, Object value) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            Constructor<R> constructor = newType.getConstructor(value.getClass());
            return constructor.newInstance(value);
        }
        catch (NoSuchMethodException e) {
            Function<Object, R> transformer = this.getTypeTransformer(newType);
            if (transformer != null) {
                return transformer.apply(value);
            }
            return value;
        }
    }

    protected Object[] createWriteMethodArguments(Method method, Object value) throws IllegalAccessException, ClassCastException {
        try {
            Class<?> paramType;
            Class<?>[] paramTypes;
            if (value != null && (paramTypes = method.getParameterTypes()) != null && paramTypes.length > 0 && !(paramType = paramTypes[0]).isAssignableFrom(value.getClass())) {
                value = this.convertType(paramType, value);
            }
            return new Object[]{value};
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Iterator<Map.Entry<String, Object>> entryIterator() {
        final Iterator<String> iter = this.keyIterator();
        return new Iterator<Map.Entry<String, Object>>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                String key = (String)iter.next();
                Object value = BeanMap.this.get(key);
                return new Entry(BeanMap.this, key, value);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return BeanMap.this.entryIterator();
            }

            @Override
            public int size() {
                return BeanMap.this.readMethods.size();
            }
        });
    }

    protected void firePropertyChange(Object key, Object oldValue, Object newValue) {
    }

    @Override
    public Object get(Object name) {
        Method method;
        if (this.bean != null && (method = this.getReadMethod(name)) != null) {
            try {
                return method.invoke(this.bean, NULL_ARGUMENTS);
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
                this.logWarn(e);
            }
        }
        return null;
    }

    public Object getBean() {
        return this.bean;
    }

    protected Method getReadMethod(Object name) {
        return this.readMethods.get(name);
    }

    public Method getReadMethod(String name) {
        return this.readMethods.get(name);
    }

    public Class<?> getType(String name) {
        return this.types.get(name);
    }

    protected <R> Function<Object, R> getTypeTransformer(Class<R> type) {
        return typeTransformers.get(type);
    }

    protected Method getWriteMethod(Object name) {
        return this.writeMethods.get(name);
    }

    public Method getWriteMethod(String name) {
        return this.writeMethods.get(name);
    }

    private void initialize() {
        if (this.getBean() == null) {
            return;
        }
        Class<?> beanClass = this.getBean().getClass();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null) {
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    if (propertyDescriptor == null) continue;
                    String name = propertyDescriptor.getName();
                    Method readMethod = propertyDescriptor.getReadMethod();
                    Method writeMethod = propertyDescriptor.getWriteMethod();
                    Class<?> aType = propertyDescriptor.getPropertyType();
                    if (readMethod != null) {
                        this.readMethods.put(name, readMethod);
                    }
                    if (writeMethod != null) {
                        this.writeMethods.put(name, writeMethod);
                    }
                    this.types.put(name, aType);
                }
            }
        }
        catch (IntrospectionException e) {
            this.logWarn(e);
        }
    }

    public Iterator<String> keyIterator() {
        return this.readMethods.keySet().iterator();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.readMethods.keySet());
    }

    protected void logInfo(Exception ex) {
        System.out.println("INFO: Exception: " + ex);
    }

    protected void logWarn(Exception ex) {
        System.out.println("WARN: Exception: " + ex);
        ex.printStackTrace();
    }

    @Override
    public Object put(String name, Object value) throws IllegalArgumentException, ClassCastException {
        if (this.bean != null) {
            Object oldValue = this.get(name);
            Method method = this.getWriteMethod(name);
            if (method == null) {
                throw new IllegalArgumentException("The bean of type: " + this.bean.getClass().getName() + " has no property called: " + name);
            }
            try {
                Object[] arguments = this.createWriteMethodArguments(method, value);
                method.invoke(this.bean, arguments);
                Object newValue = this.get(name);
                this.firePropertyChange(name, oldValue, newValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            return oldValue;
        }
        return null;
    }

    public void putAllWriteable(BeanMap map) {
        map.readMethods.keySet().forEach((? super T key) -> {
            if (this.getWriteMethod((String)key) != null) {
                this.put((String)key, map.get(key));
            }
        });
    }

    protected void reinitialise() {
        this.readMethods.clear();
        this.writeMethods.clear();
        this.types.clear();
        this.initialize();
    }

    public void setBean(Object newBean) {
        this.bean = newBean;
        this.reinitialise();
    }

    @Override
    public int size() {
        return this.readMethods.size();
    }

    @Override
    public String toString() {
        return "BeanMap<" + this.bean + ">";
    }

    public Iterator<Object> valueIterator() {
        final Iterator<String> iter = this.keyIterator();
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Object next() {
                Object key = iter.next();
                return BeanMap.this.get(key);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    @Override
    public Collection<Object> values() {
        ArrayList answer = new ArrayList(this.readMethods.size());
        this.valueIterator().forEachRemaining(answer::add);
        return Collections.unmodifiableList(answer);
    }

    protected static class Entry
    extends AbstractMap.SimpleEntry<String, Object> {
        private static final long serialVersionUID = 1L;
        private final BeanMap owner;

        protected Entry(BeanMap owner, String key, Object value) {
            super(key, value);
            this.owner = owner;
        }

        @Override
        public Object setValue(Object value) {
            String key = (String)this.getKey();
            Object oldValue = this.owner.get(key);
            this.owner.put(key, value);
            Object newValue = this.owner.get(key);
            super.setValue(newValue);
            return oldValue;
        }
    }
}

