/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stringtemplate;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.ParameterCacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.cocoon.sax.util.XMLUtils;
import org.apache.cocoon.stringtemplate.STRenderer;
import org.apache.cocoon.xml.sax.SAXBuffer;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class StringTemplateTransformer
extends AbstractSAXTransformer
implements CachingPipelineComponent {
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public void setup(Map<String, Object> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.putAll(parameters);
        }
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.setup(configuration);
    }

    public CacheKey constructCacheKey() {
        return ParameterCacheKey.getSitemapSafeInstance(this.parameters);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        super.startSAXRecording();
    }

    public void endDocument() throws SAXException {
        SAXBuffer buffer = super.endSAXRecording();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLUtils.toOutputStream((OutputStream)baos, (SAXBuffer)buffer);
        try {
            String rendered = STRenderer.getInstance().render(new String(baos.toByteArray()), this.parameters);
            XMLUtils.toSax((String)rendered, (ContentHandler)this.getSAXConsumer());
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        super.endDocument();
    }
}

