/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stringtemplate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CompoundCacheKey;
import org.apache.cocoon.pipeline.caching.ParameterCacheKey;
import org.apache.cocoon.pipeline.caching.TimestampURLCacheKey;
import org.apache.cocoon.pipeline.component.AbstractPipelineComponent;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.pipeline.component.Finisher;
import org.apache.cocoon.pipeline.component.Starter;
import org.apache.cocoon.pipeline.util.URLConnectionUtils;
import org.apache.cocoon.stringtemplate.STRenderer;
import org.apache.commons.io.IOUtils;

public class StringTemplateReader
extends AbstractPipelineComponent
implements CachingPipelineComponent,
Starter,
Finisher {
    private String mimeType;
    private OutputStream outputStream;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private URL source;

    public StringTemplateReader() {
        this(null);
    }

    public StringTemplateReader(URL source) {
        this.setSource(source);
    }

    public CacheKey constructCacheKey() {
        if (this.source == null) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " has no source.");
        }
        CompoundCacheKey cacheKey = new CompoundCacheKey();
        cacheKey.addCacheKey((CacheKey)new TimestampURLCacheKey(this.source, URLConnectionUtils.getLastModified((URL)this.source)));
        cacheKey.addCacheKey((CacheKey)new ParameterCacheKey("contextParameters", this.parameters));
        return cacheKey;
    }

    public void execute() {
        if (this.source == null) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " has no source.");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.source.openStream();
            OutputStreamWriter writer = new OutputStreamWriter(this.outputStream);
            writer.write(STRenderer.getInstance().render(IOUtils.toString((InputStream)inputStream, (String)"UTF-8"), this.parameters));
            writer.flush();
        }
        catch (IOException e) {
            throw new ProcessingException("Failed to produce result.", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public String getContentType() {
        return this.mimeType;
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.setSource((URL)configuration.get("source"));
        this.setMimeType((String)configuration.get("mime-type"));
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public final void setSource(URL source) {
        this.source = source;
    }

    public void setup(Map<String, Object> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.putAll(parameters);
        }
    }
}

