/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.stringtemplate;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.stringtemplate.LogErrorListener;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STWriter;

public final class STRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(STRenderer.class);
    private static final STRenderer SINGLETON = new STRenderer(new LogErrorListener());
    private STErrorListener errorListener;

    private STRenderer(STErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public static STRenderer getInstance() {
        return SINGLETON;
    }

    public String render(String template, Map<String, Object> parameters) throws IOException {
        ST stringTemplate = new ST(template, '$', '$');
        if (parameters == null || parameters.isEmpty()) {
            LOG.warn("There are not any parameters passed to the template.");
        } else {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                String value;
                stringTemplate.add(entry.getKey().replace(".", "_"), entry.getValue() instanceof String ? StringEscapeUtils.escapeXml((String)entry.getValue().toString()) : entry.getValue());
                if (!LOG.isDebugEnabled()) continue;
                if (entry.getValue() instanceof Map) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    MapUtils.verbosePrint((PrintStream)new PrintStream((OutputStream)baos), null, parameters);
                    baos.flush();
                    value = baos.toString();
                } else {
                    value = entry.getValue().toString();
                }
                LOG.debug("Passing parameter as ST attribute: key={}, value={}", (Object)entry.getKey(), (Object)value);
            }
        }
        StringWriter out = new StringWriter();
        AutoIndentWriter wr = new AutoIndentWriter((Writer)out);
        wr.setLineWidth(-1);
        stringTemplate.write((STWriter)wr, Locale.getDefault(), this.errorListener);
        return out.toString();
    }
}

