/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.util;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.cocoon.servletservice.AbsoluteServletConnection;
import org.apache.cocoon.servletservice.Absolutizable;

public class ServletServiceUtils {
    public static InputStream getServletServiceResource(Servlet servlet, String resourcePath) {
        return ServletServiceUtils.getServletServiceResource(servlet, resourcePath, null);
    }

    public static InputStream getServletServiceResource(Servlet servlet, String resourcePath, String query) {
        Absolutizable a;
        String resultResourcePath = resourcePath;
        if (resultResourcePath.length() > 0 && !resultResourcePath.startsWith("/")) {
            resultResourcePath = "/" + resultResourcePath;
        }
        try {
            a = (Absolutizable)servlet.getServletConfig().getServletContext();
        }
        catch (ClassCastException cce) {
            throw new ServletServiceException("The passed servlet isn't a servlet service because it can't be cast to " + Absolutizable.class.getName() + ".", cce);
        }
        AbsoluteServletConnection sc = new AbsoluteServletConnection(a.getServiceName(), resultResourcePath, query);
        try {
            return sc.getInputStream();
        }
        catch (IOException e) {
            throw new ServletServiceException(e);
        }
        catch (ServletException e) {
            throw new ServletServiceException(e);
        }
    }

    public static class ServletServiceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ServletServiceException(String message, Throwable t) {
            super(message, t);
        }

        public ServletServiceException(Throwable t) {
            super(t);
        }
    }
}

