/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.ssf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.util.URLConnectionUtils;
import org.apache.cocoon.sax.AbstractSAXSerializer;
import org.apache.cocoon.sax.util.XMLUtils;
import org.apache.cocoon.servlet.collector.ResponseHeaderCollector;
import org.apache.cocoon.xml.sax.SAXBuffer;
import org.apache.commons.io.IOUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ServletServiceSerializer
extends AbstractSAXSerializer {
    private URL service;
    private SAXBuffer saxBuffer = new SAXBuffer();
    private URLConnection servletConnection;

    public void endDocument() throws SAXException {
        if (this.service == null) {
            throw new IllegalArgumentException("ServletServiceSerializer has no service set.");
        }
        this.saxBuffer.endDocument();
        try {
            XMLUtils.toOutputStream((OutputStream)this.getUrlConnection().getOutputStream(), (SAXBuffer)this.saxBuffer);
            IOUtils.copy((InputStream)this.getUrlConnection().getInputStream(), (OutputStream)this.getOutputStream());
            URLConnection urlConnection = this.getUrlConnection();
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection servletURLConnection = (HttpURLConnection)urlConnection;
                int statusCode = servletURLConnection.getResponseCode();
                ResponseHeaderCollector.setStatusCode(statusCode);
            }
        }
        catch (IOException e) {
            throw new SAXException("Can't copy the result of the servlet service to the output stream", e);
        }
        finally {
            URLConnectionUtils.closeQuietly((URLConnection)this.getUrlConnection());
        }
    }

    public String getContentType() {
        return this.getUrlConnection().getContentType();
    }

    public void init() {
        this.setContentHandler((ContentHandler)this.saxBuffer);
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        try {
            this.service = new URL((String)configuration.get("service"));
        }
        catch (MalformedURLException e) {
            throw new SetupException("Can't create an URL for " + configuration.get("service") + ".", (Throwable)e);
        }
    }

    private URLConnection getUrlConnection() {
        if (this.servletConnection == null) {
            try {
                this.servletConnection = this.service.openConnection();
            }
            catch (IOException e) {
                throw new ProcessingException("Can't use connected servlet service: " + this.service, (Throwable)e);
            }
        }
        return this.servletConnection;
    }
}

