/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.controller;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.servlet.util.HttpContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ControllerContextHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerContextHelper.class);
    private static final String CONTEXT_OBJECT = ControllerContextHelper.class.getName();

    private ControllerContextHelper() {
    }

    public static Map<String, Object> getContext(Map<String, ? extends Object> parameters) {
        HttpServletRequest request = HttpContextHelper.getRequest(parameters);
        Object value = request.getAttribute(CONTEXT_OBJECT);
        if (value instanceof Map) {
            return ControllerContextHelper.asControllerContext(value);
        }
        if (value != null) {
            LOG.warn("The parameters contain an entry with the key {} but it is not a map.", (Object)CONTEXT_OBJECT);
        }
        return Collections.emptyMap();
    }

    public static void storeContext(Map<String, Object> controllerContext, Map<String, Object> parameters) {
        HttpServletRequest request = HttpContextHelper.getRequest(parameters);
        ControllerContextHelper.storeContext(controllerContext, request);
    }

    public static void storeContext(Map<String, Object> controllerContext, HttpServletRequest request) {
        request.setAttribute(CONTEXT_OBJECT, controllerContext);
    }

    private static Map<String, Object> asControllerContext(Object controllerContext) {
        return (Map)controllerContext;
    }
}

