/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.servlet.RequestProcessor;
import org.apache.cocoon.spring.configurator.WebAppContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;

public class XMLSitemapServlet
extends HttpServlet {
    private static final long serialVersionUID = -3357343514247739162L;
    protected static final Logger LOG = LoggerFactory.getLogger(XMLSitemapServlet.class);
    protected transient RequestProcessor requestProcessor;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.lazyInitialize();
        try {
            this.requestProcessor.service(req, resp);
        }
        catch (RuntimeException e) {
            resp.setStatus(500);
            this.wrapException(e, "Cocoon can't process the request.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInitialize() throws ServletException {
        XMLSitemapServlet xMLSitemapServlet = this;
        synchronized (xMLSitemapServlet) {
            Settings settings = (Settings)WebAppContextUtils.getCurrentWebApplicationContext().getBean(Settings.class.getName());
            if (!settings.isReloadingEnabled("sitemap") && this.requestProcessor != null) {
                return;
            }
            try {
                this.requestProcessor = new RequestProcessor(this.getServletContext(), this.getInitParameter("sitemap-path"), (BeanFactory)WebAppContextUtils.getCurrentWebApplicationContext());
            }
            catch (Exception e) {
                this.wrapException(e, "Can't initialize the RequestProcessor correctly.");
            }
        }
    }

    protected ServletException wrapException(Exception exception, String msg) {
        LOG.error(msg, (Throwable)exception);
        ServletException servletException = new ServletException(msg, (Throwable)exception);
        if (servletException.getCause() == null) {
            servletException.initCause((Throwable)exception);
        }
        return servletException;
    }
}

