/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.optional.pipeline.components.sax.jaxb;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericType<T> {
    private final T object;
    private final Class<?> rawType;
    private final Class<?> type;

    public static <T> GenericType<T> toGenericType(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Parameter 't' must not be null");
        }
        return new GenericType<T>((Object)t){};
    }

    public GenericType(T object) {
        this.object = object;
        this.rawType = object.getClass();
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterized = (ParameterizedType)superclass;
        Type type = parameterized.getActualTypeArguments()[0];
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            this.type = (Class)actualTypeArguments[0];
        } else {
            this.type = null;
        }
    }

    public final T getObject() {
        return this.object;
    }

    public final Class<?> getRawType() {
        return this.rawType;
    }

    public final Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return "{ object=" + this.object + ", rawType=" + this.rawType + ", type=" + this.type + " }";
    }
}

