/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.xml;

import java.util.ArrayList;
import java.util.List;
import org.apache.cocoon.template.xml.AttributeAwareXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class AttributeAwareXMLConsumerImpl
implements AttributeAwareXMLConsumer {
    private StartElement currentElement;
    private List saxbits;
    private Locator locator;
    private XMLConsumer delegate;

    public AttributeAwareXMLConsumerImpl(XMLConsumer consumer) {
        this.delegate = consumer;
        this.saxbits = new ArrayList();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.delegate.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.delegate.startDocument();
    }

    public void endDocument() throws SAXException {
        this.playCache();
        this.delegate.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.playCache();
        this.delegate.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.playCache();
        this.delegate.endPrefixMapping(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.playCache();
        this.currentElement = new StartElement(namespaceURI, localName, qName, attrs);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.playCache();
        this.delegate.endElement(namespaceURI, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement != null) {
            this.saxbits.add(new Characters(ch, start, length));
        } else {
            this.delegate.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.currentElement != null) {
            this.saxbits.add(new IgnorableWhitespace(ch, start, length));
        } else {
            this.delegate.ignorableWhitespace(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.playCache();
        this.delegate.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.playCache();
        this.delegate.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.playCache();
        this.delegate.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this.playCache();
        this.delegate.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        this.playCache();
        this.delegate.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        this.playCache();
        this.delegate.endEntity(name);
    }

    public void startCDATA() throws SAXException {
        this.playCache();
        this.delegate.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this.playCache();
        this.delegate.endCDATA();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.playCache();
        this.delegate.comment(ch, start, length);
    }

    @Override
    public void attribute(String uri, String localName, String qName, String type, String value) throws SAXException {
        if (this.currentElement == null) {
            throw new SAXParseException("attribute event not allowed here", this.locator);
        }
        this.currentElement.attribute(uri, localName, qName, type, value);
        boolean whitespaceOnly = true;
        for (SaxBit saxBit : this.saxbits) {
            if (saxBit instanceof IgnorableWhitespace) continue;
            whitespaceOnly = false;
        }
        if (whitespaceOnly) {
            this.saxbits.clear();
        }
    }

    public void playCache() throws SAXException {
        if (this.currentElement != null) {
            this.currentElement.send((ContentHandler)this.delegate);
            this.currentElement = null;
        }
        for (SaxBit saxBit : this.saxbits) {
            saxBit.send((ContentHandler)this.delegate);
        }
        this.saxbits.clear();
    }

    public static final class IgnorableWhitespace
    implements SaxBit {
        public final char[] ch;

        public IgnorableWhitespace(char[] ch, int start, int length) {
            this.ch = new char[length];
            System.arraycopy(ch, start, this.ch, 0, length);
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.ignorableWhitespace(this.ch, 0, this.ch.length);
        }
    }

    public static final class Characters
    implements SaxBit {
        public final char[] ch;

        public Characters(char[] ch, int start, int length) {
            this.ch = new char[length];
            System.arraycopy(ch, start, this.ch, 0, length);
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.characters(this.ch, 0, this.ch.length);
        }
    }

    private class StartElement
    implements SaxBit {
        private String namespaceURI;
        private String localName;
        private String qName;
        private AttributesImpl attrs;

        public StartElement(String namespaceURI, String localName, String qName, Attributes attrs) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.qName = qName;
            this.attrs = new AttributesImpl(attrs);
        }

        @Override
        public void send(ContentHandler contentHandler) throws SAXException {
            contentHandler.startElement(this.namespaceURI, this.localName, this.qName, this.attrs);
        }

        public void attribute(String uri, String localName, String qName, String type, String value) {
            this.attrs.addAttribute(uri, localName, qName, type, value);
        }
    }

    static interface SaxBit {
        public void send(ContentHandler var1) throws SAXException;
    }
}

