/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.instruction;

import java.util.Stack;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.script.Invoker;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Set
extends Instruction {
    private final Subst var;
    private final Subst value;

    public Set(ParsingContext parsingContext, StartElement raw, Attributes attrs, Stack stack) throws SAXException {
        super(raw);
        Locator locator = this.getLocation();
        String var = attrs.getValue("var");
        String value = attrs.getValue("value");
        Subst varExpr = null;
        Subst valueExpr = null;
        if (var != null) {
            varExpr = parsingContext.getStringTemplateParser().compileExpr(var, "set: \"var\":", locator);
        }
        if (value != null) {
            valueExpr = parsingContext.getStringTemplateParser().compileExpr(value, "set: \"value\":", locator);
        }
        this.var = varExpr;
        this.value = valueExpr;
    }

    @Override
    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        Node[] value = null;
        String var = null;
        try {
            if (this.var != null) {
                var = this.var.getStringValue(objectModel);
            }
            if (this.value != null) {
                value = this.value.getNode(objectModel);
            }
        }
        catch (Exception exc) {
            throw new SAXParseException(exc.getMessage(), this.getLocation(), exc);
        }
        if (this.value == null) {
            NodeList nodeList = Invoker.toDOMNodeList("set", this, objectModel, executionContext, macroContext, namespaces);
            int len = nodeList.getLength();
            Node[] nodeArr = new Node[len];
            for (int i = 0; i < len; ++i) {
                nodeArr[i] = nodeList.item(i);
            }
            value = nodeArr;
        }
        if (var != null) {
            objectModel.put((Object)var, (Object)value);
        }
        return this.getEndInstruction().getNext();
    }
}

