/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.instruction;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Stack;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.StringTemplateParser;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.environment.ErrorHolder;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.LocaleAwareInstruction;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FormatNumber
extends LocaleAwareInstruction {
    private Subst value;
    private Subst type;
    private Subst pattern;
    private Subst currencyCode;
    private Subst currencySymbol;
    private Subst isGroupingUsed;
    private Subst maxIntegerDigits;
    private Subst minIntegerDigits;
    private Subst maxFractionDigits;
    private Subst minFractionDigits;
    private Subst var;
    private static Class currencyClass;
    private static final String NUMBER = "number";
    private static final String CURRENCY = "currency";
    private static final String PERCENT = "percent";

    public FormatNumber(ParsingContext parsingContext, StartElement raw, Attributes attrs, Stack stack) throws SAXException {
        super(parsingContext, raw, attrs, stack);
        Locator locator = this.getLocation();
        StringTemplateParser expressionCompiler = parsingContext.getStringTemplateParser();
        this.value = expressionCompiler.compileExpr(attrs.getValue("value"), null, locator);
        this.type = expressionCompiler.compileExpr(attrs.getValue("type"), null, locator);
        this.pattern = expressionCompiler.compileExpr(attrs.getValue("pattern"), null, locator);
        this.currencyCode = expressionCompiler.compileExpr(attrs.getValue("currencyCode"), null, locator);
        this.currencySymbol = expressionCompiler.compileExpr(attrs.getValue("currencySymbol"), null, locator);
        this.isGroupingUsed = expressionCompiler.compileBoolean(attrs.getValue("isGroupingUsed"), null, locator);
        this.maxIntegerDigits = expressionCompiler.compileInt(attrs.getValue("maxIntegerDigits"), null, locator);
        this.minIntegerDigits = expressionCompiler.compileInt(attrs.getValue("minIntegerDigits"), null, locator);
        this.maxFractionDigits = expressionCompiler.compileInt(attrs.getValue("maxFractionDigits"), null, locator);
        this.minFractionDigits = expressionCompiler.compileInt(attrs.getValue("minFractionDigits"), null, locator);
        this.var = expressionCompiler.compileExpr(attrs.getValue("var"), null, locator);
    }

    @Override
    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        try {
            String result = this.format(objectModel);
            if (result != null) {
                char[] chars = result.toCharArray();
                consumer.characters(chars, 0, chars.length);
            }
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.getLocation(), e);
        }
        catch (Error err) {
            throw new SAXParseException(err.getMessage(), this.getLocation(), new ErrorHolder(err));
        }
        return this.getNext();
    }

    private String format(ObjectModel objectModel) throws Exception {
        String formatted;
        String var = this.var == null ? null : this.var.getStringValue(objectModel);
        Number input = this.value.getNumberValue(objectModel);
        String type = this.type == null ? null : this.type.getStringValue(objectModel);
        String pattern = this.pattern == null ? null : this.pattern.getStringValue(objectModel);
        String currencyCode = this.currencyCode == null ? null : this.currencyCode.getStringValue(objectModel);
        String currencySymbol = this.currencySymbol == null ? null : this.currencySymbol.getStringValue(objectModel);
        Boolean isGroupingUsed = this.isGroupingUsed == null ? null : this.isGroupingUsed.getBooleanValue(objectModel);
        Number maxIntegerDigits = this.maxIntegerDigits == null ? (Number)null : (Number)this.maxIntegerDigits.getNumberValue(objectModel);
        Number minIntegerDigits = this.minIntegerDigits == null ? (Number)null : (Number)this.minIntegerDigits.getNumberValue(objectModel);
        Number maxFractionDigits = this.maxFractionDigits == null ? (Number)null : (Number)this.maxFractionDigits.getNumberValue(objectModel);
        Number minFractionDigits = this.minFractionDigits == null ? (Number)null : (Number)this.minFractionDigits.getNumberValue(objectModel);
        Locale loc = this.getLocale(objectModel);
        if (loc != null) {
            NumberFormat formatter = null;
            if (StringUtils.isNotEmpty((String)pattern)) {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(loc);
                formatter = new DecimalFormat(pattern, symbols);
            } else {
                formatter = this.createFormatter(loc, type);
            }
            if (StringUtils.isNotEmpty((String)pattern) || CURRENCY.equalsIgnoreCase(type)) {
                this.setCurrency(formatter, currencyCode, currencySymbol);
            }
            this.configureFormatter(formatter, isGroupingUsed, maxIntegerDigits, minIntegerDigits, maxFractionDigits, minFractionDigits);
            formatted = formatter.format(input);
        } else {
            formatted = input.toString();
        }
        if (var != null) {
            objectModel.put((Object)var, (Object)formatted);
            return null;
        }
        return formatted;
    }

    private NumberFormat createFormatter(Locale loc, String type) throws Exception {
        NumberFormat formatter = null;
        if (type == null || NUMBER.equalsIgnoreCase(type)) {
            formatter = NumberFormat.getNumberInstance(loc);
        } else if (CURRENCY.equalsIgnoreCase(type)) {
            formatter = NumberFormat.getCurrencyInstance(loc);
        } else if (PERCENT.equalsIgnoreCase(type)) {
            formatter = NumberFormat.getPercentInstance(loc);
        } else {
            throw new IllegalArgumentException("Invalid type: \"" + type + "\": should be \"number\" or \"currency\" or \"percent\"");
        }
        return formatter;
    }

    private void configureFormatter(NumberFormat formatter, Boolean isGroupingUsed, Number maxIntegerDigits, Number minIntegerDigits, Number maxFractionDigits, Number minFractionDigits) {
        if (isGroupingUsed != null) {
            formatter.setGroupingUsed(isGroupingUsed);
        }
        if (maxIntegerDigits != null) {
            formatter.setMaximumIntegerDigits(maxIntegerDigits.intValue());
        }
        if (minIntegerDigits != null) {
            formatter.setMinimumIntegerDigits(minIntegerDigits.intValue());
        }
        if (maxFractionDigits != null) {
            formatter.setMaximumFractionDigits(maxFractionDigits.intValue());
        }
        if (minFractionDigits != null) {
            formatter.setMinimumFractionDigits(minFractionDigits.intValue());
        }
    }

    private void setCurrency(NumberFormat formatter, String currencyCode, String currencySymbol) throws Exception {
        String code = null;
        String symbol = null;
        if (currencyCode == null) {
            if (currencySymbol == null) {
                return;
            }
            symbol = currencySymbol;
        } else if (currencySymbol != null) {
            if (currencyClass != null) {
                code = currencyCode;
            } else {
                symbol = currencySymbol;
            }
        } else if (currencyClass != null) {
            code = currencyCode;
        } else {
            symbol = currencyCode;
        }
        if (code != null) {
            Object[] methodArgs = new Object[1];
            Method m = currencyClass.getMethod("getInstance", String.class);
            methodArgs[0] = code;
            Object currency = m.invoke(null, methodArgs);
            Class[] paramTypes = new Class[]{currencyClass};
            Class<?> numberFormatClass = Class.forName("java.text.NumberFormat");
            m = numberFormatClass.getMethod("setCurrency", paramTypes);
            methodArgs[0] = currency;
            m.invoke((Object)formatter, methodArgs);
        } else {
            DecimalFormat df = (DecimalFormat)formatter;
            DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
            dfs.setCurrencySymbol(symbol);
            df.setDecimalFormatSymbols(dfs);
        }
    }

    static {
        try {
            currencyClass = Class.forName("java.util.Currency");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

