/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.instruction;

import java.util.Stack;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.script.Invoker;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class Element
extends Instruction {
    private Subst name;
    private Subst uri;
    private Subst prefix;
    public static final String XML_ELEM_NAME_BLANK = "parameter: \"name\" is required";
    public static final String XML_ELEM_NAME_INVALID = "parameter: \"name\" is an invalid XML element name";
    public static final String XML_PREFIX_NAME_INVALID = "parameter: \"prefix\" is an Invalid XML prefix";
    public static final String XML_PREFIX_MISSING_NAMESPACE = "parameter: \"uri\" must be specified if \"prefix\" is specified";

    public Element(ParsingContext parsingContext, StartElement raw, Attributes attrs, Stack stack) throws SAXException {
        super(raw);
        this.name = this.getSubst("name", attrs, parsingContext, true);
        this.uri = this.getSubst("uri", attrs, parsingContext, false);
        this.prefix = this.getSubst("prefix", attrs, parsingContext, false);
    }

    @Override
    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        AttributesImpl EMPTY_ATTRS = new AttributesImpl();
        String nameStr = null;
        try {
            String prefixStr;
            nameStr = this.name.getStringValue(objectModel);
            String uriStr = this.uri != null ? this.uri.getStringValue(objectModel) : null;
            String string = prefixStr = this.prefix != null ? this.prefix.getStringValue(objectModel) : null;
            if (StringUtils.isBlank((String)nameStr)) {
                throw new SAXParseException(XML_ELEM_NAME_BLANK, this.getLocation());
            }
            if (!nameStr.matches("[A-Za-z][^\\s:]*")) {
                throw new SAXParseException(XML_ELEM_NAME_INVALID, this.getLocation());
            }
            if (StringUtils.isNotBlank((String)prefixStr) && !prefixStr.matches("[A-Za-z][^\\s:]*")) {
                throw new SAXParseException(XML_PREFIX_NAME_INVALID, this.getLocation());
            }
            if (StringUtils.isNotBlank((String)prefixStr) && StringUtils.isBlank((String)uriStr)) {
                throw new SAXParseException(XML_PREFIX_MISSING_NAMESPACE, this.getLocation());
            }
            String qName = StringUtils.isNotBlank((String)prefixStr) ? prefixStr + ":" + nameStr : nameStr;
            consumer.startElement(uriStr, nameStr, qName, (Attributes)EMPTY_ATTRS);
            Invoker.execute(consumer, objectModel, executionContext, macroContext, namespaces, this.getNext(), this.getEndInstruction());
            consumer.endElement(uriStr, nameStr, qName);
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.getLocation(), e);
        }
        return this.getEndInstruction().getNext();
    }

    private Subst getSubst(String attrName, Attributes attrs, ParsingContext parsingContext, boolean isRequired) throws SAXParseException {
        Locator locator = this.getLocation();
        String value = attrs.getValue(attrName);
        if (isRequired && value == null) {
            throw new SAXParseException("parameter: \"" + attrName + "\" is required", locator, null);
        }
        if (!isRequired && value == null) {
            return null;
        }
        return parsingContext.getStringTemplateParser().compileExpr(value, "parameter: \"" + attrName + "\": ", locator);
    }
}

