/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.instruction;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.Subst;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.ParsingContext;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.script.Invoker;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.template.xml.AttributeAwareXMLConsumer;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.apache.commons.lang.StringUtils;
import org.apache.xml.serialize.TextSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class Attribute
extends Instruction {
    public static final String XML_ATTR_NAME_BLANK = "parameter: \"name\" is required";
    public static final String XML_ATTR_NAME_INVALID = "parameter: \"name\" is an invalid XML attribute name";
    private Subst name;
    private Subst value;

    public Attribute(ParsingContext parsingContext, StartElement raw, Attributes attrs, Stack stack) throws SAXException {
        super(raw);
        this.name = this.getSubst("name", attrs, parsingContext, true);
        this.value = this.getSubst("value", attrs, parsingContext, false);
    }

    @Override
    public Event execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        String nameStr = null;
        String valueStr = "";
        try {
            nameStr = this.name.getStringValue(objectModel);
            if (StringUtils.isBlank((String)nameStr)) {
                throw new SAXParseException(XML_ATTR_NAME_BLANK, this.getLocation());
            }
            if (!nameStr.matches("[A-Za-z][^\\s:]*")) {
                throw new SAXParseException(XML_ATTR_NAME_INVALID, this.getLocation());
            }
            if (this.value != null) {
                valueStr = this.value.getStringValue(objectModel);
            } else {
                TextSerializer serializer = new TextSerializer();
                StringWriter writer = new StringWriter();
                serializer.setOutputCharStream((Writer)writer);
                ContentHandlerWrapper contentHandler = new ContentHandlerWrapper((ContentHandler)serializer, (LexicalHandler)serializer);
                contentHandler.startDocument();
                Invoker.execute((XMLConsumer)contentHandler, objectModel, executionContext, macroContext, namespaces, this.getNext(), this.getEndInstruction());
                contentHandler.endDocument();
                valueStr = writer.toString();
            }
        }
        catch (Exception exc) {
            throw new SAXParseException(exc.getMessage(), this.getLocation(), exc);
        }
        if (!(consumer instanceof AttributeAwareXMLConsumer)) {
            throw new SAXParseException("consumer is not attribute aware", this.getLocation());
        }
        AttributeAwareXMLConsumer c = (AttributeAwareXMLConsumer)consumer;
        c.attribute("", nameStr, nameStr, "CDATA", valueStr == null ? "" : valueStr);
        return this.getEndInstruction().getNext();
    }

    private Subst getSubst(String attrName, Attributes attrs, ParsingContext parsingContext, boolean isRequired) throws SAXParseException {
        Locator locator = this.getLocation();
        String value = attrs.getValue(attrName);
        if (isRequired && value == null) {
            throw new SAXParseException("parameter: \"" + attrName + "\" is required", locator, null);
        }
        if (!isRequired && value == null) {
            return null;
        }
        return parsingContext.getStringTemplateParser().compileExpr(value, "parameter: \"" + attrName + "\": ", locator);
    }
}

