/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import java.io.File;
import java.io.IOException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.util.IOUtils;
import org.apache.cocoon.util.avalon.CLLoggerWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.store.impl.AbstractFilesystemStore;

public final class FilesystemStore
extends AbstractFilesystemStore {
    private static final boolean USE_CACHE_DIRECTORY = false;
    private static final boolean USE_WORK_DIRECTORY = false;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Settings settings;
    private boolean useCacheDirectory = false;
    private boolean useWorkDirectory = false;
    private String directory;
    protected File workDir;
    protected File cacheDir;

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setUseCacheDirectory(boolean useCacheDirectory) {
        this.useCacheDirectory = useCacheDirectory;
    }

    public void setUseWorkDirectory(boolean useWorkDirectory) {
        this.useWorkDirectory = useWorkDirectory;
    }

    public void init() throws Exception {
        this.enableLogging((Logger)new CLLoggerWrapper(this.logger));
        this.workDir = new File(this.settings.getWorkDirectory());
        this.cacheDir = new File(this.settings.getCacheDirectory());
        try {
            if (this.useCacheDirectory) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using cache directory: " + this.cacheDir);
                }
                this.setDirectory(this.cacheDir);
            } else if (this.useWorkDirectory) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using work directory: " + this.workDir);
                }
                this.setDirectory(this.workDir);
            } else if (this.directory != null) {
                this.directory = IOUtils.getContextFilePath((String)this.workDir.getPath(), (String)this.directory);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using directory: " + this.directory);
                }
                this.setDirectory(new File(this.directory));
            } else {
                try {
                    this.setDirectory(this.workDir);
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            throw new Exception("Unable to set directory", e);
        }
    }
}

