/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.cocoon.configuration.Settings;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;

public class EHDefaultStore
implements Store {
    private static final int MAX_MEM_OBJECTS = 10000;
    private static final int MAX_DISK_OBJECTS = 50000;
    private static final boolean OVERFLOW_TO_DISK = true;
    private static final boolean DISK_PERSISTENT = true;
    private static final boolean ETERNAL = true;
    private static final long TIME_TO_LIVE_SECONDS = 0L;
    private static final long TIME_TO_IDLE_SECONDS = 0L;
    private static final long DISK_EXPIRY_THREAD_INTERVAL_SECONDS = 120L;
    private static final boolean USE_WORK_DIRECTORY = false;
    private static final boolean USE_CACHE_DIRECTORY = false;
    private static final String DEFAULT_CACHE_NAME = "cocoon-ehcache";
    private static final String CONFIG_FILE = "org/apache/cocoon/components/store/impl/ehcache.xml";
    private static int instanceCount = 0;
    private Log logger = LogFactory.getLog(this.getClass());
    private Cache cache;
    private CacheManager cacheManager;
    private int maxMemObjects = 10000;
    private int maxDiskObjects = 50000;
    private boolean overflowToDisk = true;
    private boolean diskPersistent = true;
    private boolean eternal = true;
    private long timeToLiveSeconds = 0L;
    private long timeToIdleSeconds = 0L;
    private boolean useCacheDirectory = false;
    private boolean useWorkDirectory = false;
    private long diskExpiryThreadIntervalSeconds = 120L;
    private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy;
    private RegisteredEventListeners registeredEventListeners;
    private BootstrapCacheLoader bootstrapCacheLoader;
    private Settings settings;
    private StoreJanitor storeJanitor;
    private String cacheName;
    private String directory;
    private File workDir;
    private File cacheDir;
    private String diskStorePath;

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public void setMaxMemObjects(int maxMemObjects) {
        this.maxMemObjects = maxMemObjects;
    }

    public void setMaxDiskObjects(int maxDiskObjects) {
        this.maxDiskObjects = maxDiskObjects;
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public void setTimeToIdleSeconds(long timeToIdleSeconds) {
        this.timeToIdleSeconds = timeToIdleSeconds;
    }

    public void setTimeToLiveSeconds(long timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public void setDiskExpiryThreadIntervalSeconds(int diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public void setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public void setRegisteredEventListeners(RegisteredEventListeners registeredEventListeners) {
        this.registeredEventListeners = registeredEventListeners;
    }

    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) {
        this.bootstrapCacheLoader = bootstrapCacheLoader;
    }

    public void setUseCacheDirectory(boolean useCacheDirectory) {
        this.useCacheDirectory = useCacheDirectory;
    }

    public void setUseWorkDirectory(boolean useWorkDirectory) {
        this.useWorkDirectory = useWorkDirectory;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setStoreJanitor(StoreJanitor storeJanitor) {
        this.storeJanitor = storeJanitor;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log l) {
        this.logger = l;
    }

    private void setDirectory(File directory) throws IOException {
        String directoryPath = EHDefaultStore.getFullFilename(directory);
        directoryPath = directoryPath + File.separator;
        if (!directory.exists() && !directory.mkdir()) {
            throw new IOException("Error creating store directory '" + directoryPath + "': ");
        }
        if (!directory.isDirectory()) {
            throw new IOException("'" + directoryPath + "' is not a directory");
        }
        if (!directory.canRead() || !directory.canWrite()) {
            throw new IOException("Directory '" + directoryPath + "' is not readable/writable");
        }
        this.diskStorePath = directoryPath;
    }

    private static String getFullFilename(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    public void init() throws Exception {
        this.workDir = new File(this.settings.getWorkDirectory());
        this.cacheDir = new File(this.settings.getCacheDirectory());
        try {
            if (this.useCacheDirectory) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Using cache directory: " + this.cacheDir));
                }
                this.setDirectory(this.cacheDir);
            } else if (this.useWorkDirectory) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Using work directory: " + this.workDir));
                }
                this.setDirectory(this.workDir);
            } else if (this.directory != null) {
                this.directory = org.apache.cocoon.util.IOUtils.getContextFilePath((String)this.workDir.getPath(), (String)this.directory);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Using directory: " + this.directory));
                }
                this.setDirectory(new File(this.directory));
            } else {
                try {
                    this.setDirectory(this.workDir);
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            throw new Exception("Unable to set directory", e);
        }
        String config = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(CONFIG_FILE));
        config = StringUtils.replace((String)config, (String)"${diskstorepath}", (String)this.diskStorePath);
        this.cacheManager = CacheManager.create((InputStream)new ByteArrayInputStream(config.getBytes("utf-8")));
        this.cacheName = this.cacheManager.getCache(DEFAULT_CACHE_NAME) != null ? "cocoon-ehcache-" + ++instanceCount : DEFAULT_CACHE_NAME;
        this.cache = new Cache(this.cacheName, this.maxMemObjects, this.memoryStoreEvictionPolicy, this.overflowToDisk, this.diskStorePath, this.eternal, this.timeToLiveSeconds, this.timeToIdleSeconds, this.diskPersistent, this.diskExpiryThreadIntervalSeconds, this.registeredEventListeners, this.bootstrapCacheLoader, this.maxDiskObjects);
        this.cacheManager.addCache(this.cache);
        if (this.storeJanitor != null) {
            this.storeJanitor.register((Store)this);
        }
        this.getLogger().info((Object)("EHCache cache '" + this.cacheName + "' initialized"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.storeJanitor != null) {
            this.storeJanitor.unregister((Store)this);
        }
        Cache cache = this.cache;
        synchronized (cache) {
            if (Status.STATUS_ALIVE == this.cache.getStatus()) {
                try {
                    this.getLogger().info((Object)("Disposing EHCache cache '" + this.cacheName + "'."));
                    this.cacheManager.shutdown();
                }
                catch (IllegalStateException e) {
                    this.getLogger().error((Object)("Error disposing EHCache cache '" + this.cacheName + "'."), (Throwable)e);
                }
            } else {
                this.getLogger().info((Object)("EHCache cache '" + this.cacheName + "' already disposed."));
            }
        }
    }

    public Object get(Object key) {
        Serializable value = null;
        try {
            Element element = this.cache.get((Serializable)key);
            if (element != null) {
                value = element.getValue();
            }
        }
        catch (CacheException e) {
            this.getLogger().error((Object)"Failure retrieving object from store", (Throwable)e);
        }
        if (this.getLogger().isDebugEnabled()) {
            if (value != null) {
                this.getLogger().debug((Object)("Found key: " + key));
            } else {
                this.getLogger().debug((Object)("NOT Found key: " + key));
            }
        }
        return value;
    }

    public void store(Object key, Object value) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Store object " + value + " with key " + key));
        }
        if (!(key instanceof Serializable)) {
            throw new IOException("Key of class " + key.getClass().getName() + " is not Serializable");
        }
        if (!(value instanceof Serializable)) {
            throw new IOException("Value of class " + value.getClass().getName() + " is not Serializable");
        }
        Element element = new Element((Serializable)key, (Serializable)value);
        this.cache.put(element);
    }

    public void free() {
        block5: {
            try {
                List keys = this.cache.getKeysNoDuplicateCheck();
                if (!keys.isEmpty()) {
                    Serializable key = (Serializable)keys.get(0);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"Freeing cache");
                        this.getLogger().debug((Object)("key: " + key));
                        this.getLogger().debug((Object)("value: " + this.cache.get(key)));
                    }
                    if (!this.cache.remove(key) && this.getLogger().isInfoEnabled()) {
                        this.getLogger().info((Object)"Concurrency condition in free()");
                    }
                }
            }
            catch (CacheException e) {
                if (!this.getLogger().isWarnEnabled()) break block5;
                this.getLogger().warn((Object)"Error in free()", (Throwable)e);
            }
        }
    }

    public void remove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Removing item " + key));
        }
        this.cache.remove((Serializable)key);
    }

    public void clear() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Clearing the store");
        }
        this.cache.removeAll();
    }

    public boolean containsKey(Object key) {
        try {
            return this.cache.get((Serializable)key) != null;
        }
        catch (CacheException e) {
            this.getLogger().error((Object)"Failure retrieving object from store", (Throwable)e);
            return false;
        }
    }

    public Enumeration keys() {
        List keys;
        try {
            keys = this.cache.getKeys();
        }
        catch (CacheException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)"Error while getting cache keys", (Throwable)e);
            }
            keys = Collections.EMPTY_LIST;
        }
        return Collections.enumeration(keys);
    }

    public int size() {
        try {
            return (int)this.cache.getMemoryStoreSize();
        }
        catch (IllegalStateException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)"Error while getting cache size", (Throwable)e);
            }
            return 0;
        }
    }
}

