/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public final class RequestParameters
implements Serializable {
    private final Map values = new HashMap(5);

    public RequestParameters(String queryString) {
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String pair = st.nextToken();
                int pos = pair.indexOf(61);
                if (pos != -1) {
                    this.setParameter(RequestParameters.decode(pair.substring(0, pos)), RequestParameters.decode(pair.substring(pos + 1, pair.length())));
                    continue;
                }
                this.setParameter(RequestParameters.decode(pair), "");
            }
        }
    }

    private void setParameter(String name, String value) {
        String[] values = (String[])this.values.get(name);
        if (values == null) {
            values = new String[]{value};
        } else {
            String[] v2 = new String[values.length + 1];
            System.arraycopy(values, 0, v2, 0, values.length);
            v2[values.length] = value;
            values = v2;
        }
        this.values.put(name, values);
    }

    public String getParameter(String name) {
        String[] values = (String[])this.values.get(name);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String getParameter(String name, String defaultValue) {
        String[] values = (String[])this.values.get(name);
        if (values != null) {
            return values[0];
        }
        return defaultValue;
    }

    public String[] getParameterValues(String name) {
        return (String[])this.values.get(name);
    }

    public Enumeration getParameterNames() {
        return new IteratorEnumeration(this.values.keySet().iterator());
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.values);
    }

    private static String decode(String s) {
        byte[] decoded = new byte[s.length() / 3 + 1];
        int decodedLength = 0;
        int length = s.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        block11: while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    continue block11;
                }
                case '%': {
                    try {
                        if (s.charAt(i + 1) == 'u') {
                            sb.append((char)Integer.parseInt(s.substring(i + 2, i + 6), 16));
                            i += 6;
                            continue block11;
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid query string. Illegal hex characters in pattern %" + s.substring(i + 1, i + 6));
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("Invalid query string. % character should be followed by 2 hexadecimal characters.");
                    }
                    while (i < length && s.charAt(i) == '%') {
                        if (i + 2 >= length) {
                            throw new IllegalArgumentException("Invalid query string. % character should be followed by 2 hexadecimal characters.");
                        }
                        if (s.charAt(i + 1) == 'u') {
                            --i;
                            break;
                        }
                        try {
                            decoded[decodedLength++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid query string. Illegal hex characters in pattern %" + s.substring(i + 1, i + 3));
                        }
                        i += 3;
                    }
                    if (decodedLength <= 0) continue block11;
                    try {
                        sb.append(new String(decoded, 0, decodedLength, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Problem in decode: UTF-8 encoding not supported.");
                    }
                    decodedLength = 0;
                    continue block11;
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }
}

