/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletscope;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public class ServletScope
implements Scope {
    private static final String DESTRUCTION_CALLBACKS_ATTRIBUTENAME = ServletScope.class.getName() + "/destructionCallbacks";
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Object get(String name, ObjectFactory objectFactory) {
        Object scopedObject = this.servletContext.getAttribute(name);
        if (scopedObject == null) {
            scopedObject = objectFactory.getObject();
            this.servletContext.setAttribute(name, scopedObject);
        }
        return scopedObject;
    }

    public Object remove(String name) {
        Object scopedObject = this.servletContext.getAttribute(name);
        if (scopedObject != null) {
            this.servletContext.removeAttribute(name);
        }
        return scopedObject;
    }

    public String getConversationId() {
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        Map<String, Runnable> destructionCallbacks = ServletScope.getDestructionCallbacks(this.servletContext);
        destructionCallbacks.put(name, callback);
    }

    private static Map<String, Runnable> getDestructionCallbacks(ServletContext servletContext) {
        HashMap destructionCallbacks = (HashMap)servletContext.getAttribute(DESTRUCTION_CALLBACKS_ATTRIBUTENAME);
        if (destructionCallbacks == null) {
            destructionCallbacks = new HashMap();
            servletContext.setAttribute(DESTRUCTION_CALLBACKS_ATTRIBUTENAME, destructionCallbacks);
        }
        return destructionCallbacks;
    }

    public static void executeDestructionCallbacks(ServletContext servletContext) {
        Map<String, Runnable> destructionCallbacks = ServletScope.getDestructionCallbacks(servletContext);
        Iterator<Runnable> i = destructionCallbacks.values().iterator();
        while (i.hasNext()) {
            i.next().run();
        }
    }

    public Object resolveContextualObject(String key) {
        return null;
    }
}

