/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.EmbeddedXMLPipe;
import org.apache.cocoon.xml.ImmutableAttributesImpl;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XMLUtils {
    public static final Attributes EMPTY_ATTRIBUTES = new ImmutableAttributesImpl();
    private static final SAXTransformerFactory FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
    private static final Properties XML_FORMAT = XMLUtils.createDefaultPropertiesForXML(false);
    private static final Properties XML_FORMAT_NODECL = XMLUtils.createDefaultPropertiesForXML(true);

    public static void stripDuplicateAttributes(Node node, Node parent) {
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
                    XMLUtils.stripDuplicateAttributes(child, node);
                }
                break;
            }
            case 1: {
                int i;
                Element elt = (Element)node;
                NamedNodeMap attrs = elt.getAttributes();
                ArrayList<Node> nodesToRemove = new ArrayList<Node>();
                int nodesToRemoveNum = 0;
                for (i = 0; i < attrs.getLength(); ++i) {
                    Node a = attrs.item(i);
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        Node b = attrs.item(j);
                        if (i == j || !a.getNodeName().equals(b.getNodeName())) continue;
                        nodesToRemove.add(b);
                        ++nodesToRemoveNum;
                    }
                }
                for (i = 0; i < nodesToRemoveNum; ++i) {
                    Attr nodeToDelete = (Attr)nodesToRemove.get(i);
                    Element nodeToDeleteParent = (Element)node;
                    nodeToDeleteParent.removeAttributeNode(nodeToDelete);
                }
                nodesToRemove.clear();
                for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
                    XMLUtils.stripDuplicateAttributes(child, node);
                }
                break;
            }
        }
    }

    public static XMLConsumer getConsumer(ContentHandler ch, LexicalHandler lh) {
        if (ch instanceof XMLConsumer) {
            return (XMLConsumer)ch;
        }
        if (lh == null && ch instanceof LexicalHandler) {
            lh = (LexicalHandler)((Object)ch);
        }
        return new ContentHandlerWrapper(ch, lh);
    }

    public static XMLConsumer getConsumer(ContentHandler ch) {
        return XMLUtils.getConsumer(ch, null);
    }

    private static Properties createDefaultPropertiesForXML(boolean omitXMLDeclaration) {
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
        format.put("indent", "yes");
        return format;
    }

    public static Properties createPropertiesForXML(boolean omitXMLDeclaration) {
        Properties propertiesForXML = new Properties(omitXMLDeclaration ? XML_FORMAT_NODECL : XML_FORMAT);
        Enumeration<?> e = propertiesForXML.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            propertiesForXML.setProperty(propertyName, propertiesForXML.getProperty(propertyName, ""));
        }
        return propertiesForXML;
    }

    public static String serializeNode(Node node) throws ProcessingException {
        return XMLUtils.serializeNode(node, XML_FORMAT);
    }

    public static String serializeNode(Node node, Properties format) throws ProcessingException {
        try {
            if (node == null) {
                return "";
            }
            StringWriter writer = new StringWriter();
            TransformerHandler transformerHandler = FACTORY.newTransformerHandler();
            transformerHandler.getTransformer().setOutputProperties(format);
            transformerHandler.setResult(new StreamResult(writer));
            if (node.getNodeType() != 9) {
                transformerHandler.startDocument();
            }
            DOMStreamer domStreamer = new DOMStreamer(transformerHandler, transformerHandler);
            domStreamer.stream(node);
            if (node.getNodeType() != 9) {
                transformerHandler.endDocument();
            }
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new ProcessingException("TransformerException: " + e, (Throwable)e);
        }
        catch (SAXException e) {
            throw new ProcessingException("SAXException while streaming DOM node to SAX: " + e, (Throwable)e);
        }
    }

    public static String serialize(XMLizable xml, Properties format) throws ProcessingException {
        try {
            if (xml == null) {
                return "";
            }
            StringWriter writer = new StringWriter();
            TransformerHandler transformerHandler = FACTORY.newTransformerHandler();
            transformerHandler.getTransformer().setOutputProperties(format);
            transformerHandler.setResult(new StreamResult(writer));
            transformerHandler.startDocument();
            xml.toSAX((ContentHandler)((Object)new EmbeddedXMLPipe(transformerHandler)));
            transformerHandler.endDocument();
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new ProcessingException("TransformerException: " + e, (Throwable)e);
        }
        catch (SAXException e) {
            throw new ProcessingException("SAXException while streaming DOM node to SAX: " + e, (Throwable)e);
        }
    }

    public static void data(ContentHandler contentHandler, String data) throws SAXException {
        contentHandler.characters(data.toCharArray(), 0, data.length());
    }

    public static void valueOf(ContentHandler contentHandler, String text) throws SAXException {
        if (text != null) {
            XMLUtils.data(contentHandler, text);
        }
    }

    public static void valueOf(ContentHandler contentHandler, XMLizable v) throws SAXException {
        if (v != null) {
            v.toSAX(contentHandler);
        }
    }

    public static void valueOf(ContentHandler contentHandler, Node v) throws SAXException {
        if (v != null) {
            DOMStreamer streamer = new DOMStreamer(contentHandler);
            if (contentHandler instanceof LexicalHandler) {
                streamer.setLexicalHandler((LexicalHandler)((Object)contentHandler));
            }
            streamer.stream(v);
        }
    }

    public static void valueOf(ContentHandler contentHandler, Collection v) throws SAXException {
        if (v != null) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                XMLUtils.valueOf(contentHandler, iterator.next());
            }
        }
    }

    public static void valueOf(ContentHandler contentHandler, Object v) throws SAXException {
        if (v == null) {
            return;
        }
        if (v.getClass().isArray()) {
            Object[] elements = (Object[])v;
            for (int i = 0; i < elements.length; ++i) {
                XMLUtils.valueOf(contentHandler, elements[i]);
            }
            return;
        }
        if (v instanceof XMLizable) {
            XMLUtils.valueOf(contentHandler, (XMLizable)v);
            return;
        }
        if (v instanceof Node) {
            XMLUtils.valueOf(contentHandler, (Node)v);
            return;
        }
        if (v instanceof Collection) {
            XMLUtils.valueOf(contentHandler, (Collection)v);
            return;
        }
        XMLUtils.data(contentHandler, String.valueOf(v));
    }

    public static void createElement(ContentHandler contentHandler, String localName) throws SAXException {
        XMLUtils.startElement(contentHandler, localName);
        XMLUtils.endElement(contentHandler, localName);
    }

    public static void createElement(ContentHandler contentHandler, String localName, String stringValue) throws SAXException {
        XMLUtils.startElement(contentHandler, localName);
        XMLUtils.data(contentHandler, stringValue);
        XMLUtils.endElement(contentHandler, localName);
    }

    public static void createElement(ContentHandler contentHandler, String localName, Attributes atts) throws SAXException {
        XMLUtils.startElement(contentHandler, localName, atts);
        XMLUtils.endElement(contentHandler, localName);
    }

    public static void createElement(ContentHandler contentHandler, String localName, Attributes atts, String stringValue) throws SAXException {
        XMLUtils.startElement(contentHandler, localName, atts);
        XMLUtils.data(contentHandler, stringValue);
        XMLUtils.endElement(contentHandler, localName);
    }

    public static void createElementNS(ContentHandler contentHandler, String namespaceURI, String localName) throws SAXException {
        XMLUtils.startElement(contentHandler, namespaceURI, localName);
        XMLUtils.endElement(contentHandler, namespaceURI, localName);
    }

    public static void createElementNS(ContentHandler contentHandler, String namespaceURI, String localName, String stringValue) throws SAXException {
        XMLUtils.startElement(contentHandler, namespaceURI, localName);
        XMLUtils.data(contentHandler, stringValue);
        XMLUtils.endElement(contentHandler, namespaceURI, localName);
    }

    public static void createElementNS(ContentHandler contentHandler, String namespaceURI, String localName, Attributes atts) throws SAXException {
        XMLUtils.startElement(contentHandler, namespaceURI, localName, atts);
        XMLUtils.endElement(contentHandler, namespaceURI, localName);
    }

    public static void createElementNS(ContentHandler contentHandler, String namespaceURI, String localName, Attributes atts, String stringValue) throws SAXException {
        XMLUtils.startElement(contentHandler, namespaceURI, localName, atts);
        XMLUtils.data(contentHandler, stringValue);
        XMLUtils.endElement(contentHandler, namespaceURI, localName);
    }

    public static void endElement(ContentHandler contentHandler, String localName) throws SAXException {
        contentHandler.endElement("", localName, localName);
    }

    public static void endElement(ContentHandler contentHandler, String namespaceURI, String localName) throws SAXException {
        contentHandler.endElement(namespaceURI, localName, localName);
    }

    public static void startElement(ContentHandler contentHandler, String localName) throws SAXException {
        contentHandler.startElement("", localName, localName, EMPTY_ATTRIBUTES);
    }

    public static void startElement(ContentHandler contentHandler, String namespaceURI, String localName) throws SAXException {
        contentHandler.startElement(namespaceURI, localName, localName, EMPTY_ATTRIBUTES);
    }

    public static void startElement(ContentHandler contentHandler, String localName, Attributes atts) throws SAXException {
        contentHandler.startElement("", localName, localName, atts);
    }

    public static void startElement(ContentHandler contentHandler, String namespaceURI, String localName, Attributes atts) throws SAXException {
        contentHandler.startElement(namespaceURI, localName, localName, atts);
    }
}

