/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.transformation.helpers.ParametersRecorder;
import org.apache.cocoon.transformation.helpers.TextRecorder;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.TraxErrorHandler;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.ImmutableAttributesImpl;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractSAXTransformer
extends AbstractTransformer
implements Serviceable,
Configurable,
Disposable {
    protected static final Attributes EMPTY_ATTRIBUTES = XMLUtils.EMPTY_ATTRIBUTES;
    private SAXTransformerFactory tfactory;
    protected boolean ignoreWhitespaces;
    protected boolean ignoreEmptyCharacters;
    protected int ignoreEventsCount;
    protected int ignoreHooksCount;
    protected String namespaceURI;
    protected String defaultNamespaceURI;
    protected final Stack stack = new Stack();
    protected final Stack recorderStack = new Stack();
    protected Request request;
    protected Response response;
    protected Context context;
    protected Map objectModel;
    protected Parameters parameters;
    protected String source;
    protected ServiceManager manager;
    protected SourceResolver resolver;
    private boolean isInitialized;
    private final List namespaces = new ArrayList(5);
    private String ourPrefix;
    protected boolean removeOurNamespacePrefixes = false;
    private LexicalHandler originalLexicalHandler;
    private ContentHandler originalContentHandler;

    public void service(ServiceManager aManager) throws ServiceException {
        this.manager = aManager;
    }

    /*
     * Unable to fully structure code
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        tFactoryClass = configuration.getChild("transformer-factory").getValue(null);
        if (tFactoryClass != null) {
            try {
                this.tfactory = (SAXTransformerFactory)ClassUtils.newInstance((String)tFactoryClass);
                if (!this.getLogger().isDebugEnabled()) ** GOTO lbl11
                this.getLogger().debug((Object)("Using transformer factory " + tFactoryClass));
            }
            catch (Exception e) {
                throw new ConfigurationException("Cannot load transformer factory " + tFactoryClass, (Throwable)e);
            }
        } else {
            this.tfactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
lbl11:
        // 3 sources

        this.tfactory.setErrorListener((ErrorListener)new TraxErrorHandler(this.getLogger()));
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters params) throws ProcessingException, SAXException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Setup resolver=" + resolver + ", objectModel=" + objectModel + ", src=" + src + ", parameters=" + params));
        }
        if (this.defaultNamespaceURI == null) {
            this.defaultNamespaceURI = "";
        }
        this.objectModel = objectModel;
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
        this.response = ObjectModelHelper.getResponse((Map)objectModel);
        this.context = ObjectModelHelper.getContext((Map)objectModel);
        this.resolver = resolver;
        this.parameters = params;
        this.source = src;
        this.isInitialized = false;
        this.namespaceURI = params.getParameter("namespaceURI", this.defaultNamespaceURI);
        this.ignoreHooksCount = 0;
        this.ignoreEventsCount = 0;
        this.ignoreWhitespaces = true;
        this.ignoreEmptyCharacters = false;
    }

    @Override
    public void recycle() {
        this.namespaceURI = null;
        this.objectModel = null;
        this.request = null;
        this.response = null;
        this.context = null;
        this.resolver = null;
        this.stack.clear();
        this.recorderStack.clear();
        this.parameters = null;
        this.source = null;
        this.namespaces.clear();
        this.ourPrefix = null;
        super.recycle();
    }

    public void dispose() {
        this.manager = null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.ignoreEventsCount == 0) {
            super.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (!this.isInitialized) {
            try {
                this.setupTransforming();
            }
            catch (ProcessingException e) {
                throw new SAXException("ProcessingException: " + (Object)((Object)e), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new SAXException("IOException: " + e, e);
            }
            this.isInitialized = true;
        }
        if (this.ignoreEventsCount == 0) {
            super.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        boolean isOurPrefix = false;
        if (prefix != null) {
            this.namespaces.add(new String[]{prefix, uri});
        }
        if (this.namespaceURI.equals(uri)) {
            this.ourPrefix = prefix;
            isOurPrefix = true;
        }
        if (!(this.ignoreEventsCount != 0 || this.removeOurNamespacePrefixes && isOurPrefix)) {
            super.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        boolean isOurPrefix = false;
        if (prefix != null) {
            String[] prefixAndUri;
            int i;
            boolean found = false;
            for (i = this.namespaces.size() - 1; i >= 0; --i) {
                prefixAndUri = (String[])this.namespaces.get(i);
                if (!prefixAndUri[0].equals(prefix)) continue;
                this.namespaces.remove(i);
                found = true;
                break;
            }
            if (!found) {
                throw new SAXException("Namespace for prefix '" + prefix + "' not found.");
            }
            if (prefix.equals(this.ourPrefix)) {
                isOurPrefix = true;
                this.ourPrefix = null;
                for (i = this.namespaces.size() - 1; i >= 0; --i) {
                    prefixAndUri = (String[])this.namespaces.get(i);
                    if (!this.namespaceURI.equals(prefixAndUri[1])) continue;
                    this.ourPrefix = prefixAndUri[0];
                    break;
                }
            }
        }
        if (!(this.ignoreEventsCount != 0 || this.removeOurNamespacePrefixes && isOurPrefix)) {
            super.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.namespaceURI.equals(uri) && this.ignoreHooksCount == 0) {
            try {
                this.startTransformingElement(uri, name, raw, attr);
            }
            catch (ProcessingException e) {
                throw new SAXException("ProcessingException: " + (Object)((Object)e), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new SAXException("IOException occured during processing: " + e, e);
            }
        } else if (this.ignoreEventsCount == 0) {
            super.startElement(uri, name, raw, attr);
        }
    }

    @Override
    public void endElement(String uri, String name, String raw) throws SAXException {
        if (this.namespaceURI.equals(uri) && this.ignoreHooksCount == 0) {
            try {
                this.endTransformingElement(uri, name, raw);
            }
            catch (ProcessingException e) {
                throw new SAXException("ProcessingException: " + (Object)((Object)e), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new SAXException("IOException occured during processing: " + e, e);
            }
        } else if (this.ignoreEventsCount == 0) {
            super.endElement(uri, name, raw);
        }
    }

    @Override
    public void characters(char[] p0, int p1, int p2) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            if (this.ignoreEmptyCharacters) {
                String value = new String(p0, p1, p2);
                if (value.trim().length() > 0) {
                    super.characters(p0, p1, p2);
                }
            } else {
                super.characters(p0, p1, p2);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] p0, int p1, int p2) throws SAXException {
        if (!this.ignoreWhitespaces && this.ignoreEventsCount == 0) {
            super.ignorableWhitespace(p0, p1, p2);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.skippedEntity(name);
        }
    }

    @Override
    public void startDTD(String name, String public_id, String system_id) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startDTD(name, public_id, system_id);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endCDATA();
        }
    }

    @Override
    public void comment(char[] ary, int start, int length) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.comment(ary, start, length);
        }
    }

    protected void addRecorder(XMLConsumer recorder) {
        if (this.recorderStack.empty()) {
            this.originalLexicalHandler = this.lexicalHandler;
            this.originalContentHandler = this.contentHandler;
        }
        this.setContentHandler((ContentHandler)recorder);
        this.setLexicalHandler((LexicalHandler)recorder);
        this.recorderStack.push(recorder);
    }

    protected Object removeRecorder() {
        Object recorder = this.recorderStack.pop();
        if (this.recorderStack.empty()) {
            this.setContentHandler(this.originalContentHandler);
            this.setLexicalHandler(this.originalLexicalHandler);
            this.originalLexicalHandler = null;
            this.originalContentHandler = null;
        } else {
            XMLConsumer next = (XMLConsumer)this.recorderStack.peek();
            this.setContentHandler((ContentHandler)next);
            this.setLexicalHandler((LexicalHandler)next);
        }
        return recorder;
    }

    public void startSAXRecording() throws SAXException {
        this.addRecorder(new SaxBuffer());
        this.sendStartPrefixMapping();
    }

    public XMLizable endSAXRecording() throws SAXException {
        this.sendEndPrefixMapping();
        return (XMLizable)this.removeRecorder();
    }

    public void startTextRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Start text recording");
        }
        this.addRecorder(new TextRecorder());
        this.sendStartPrefixMapping();
    }

    public String endTextRecording() throws SAXException {
        this.sendEndPrefixMapping();
        TextRecorder recorder = (TextRecorder)this.removeRecorder();
        String text = recorder.getText();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("End text recording. Text=" + text));
        }
        return text;
    }

    public void startSerializedXMLRecording(Properties format) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Start serialized XML recording. Format=" + format));
        }
        this.stack.push(format == null ? XMLUtils.createPropertiesForXML(false) : format);
        this.startSAXRecording();
    }

    public String endSerializedXMLRecording() throws SAXException, ProcessingException {
        XMLizable xml = this.endSAXRecording();
        String text = XMLUtils.serialize(xml, (Properties)this.stack.pop());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("End serialized XML recording. XML=" + text));
        }
        return text;
    }

    public void startParametersRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Start parameters recording");
        }
        this.addRecorder(new ParametersRecorder());
        this.sendStartPrefixMapping();
    }

    public SourceParameters endParametersRecording(Parameters additionalParameters) throws SAXException {
        this.sendEndPrefixMapping();
        ParametersRecorder recorder = (ParametersRecorder)this.removeRecorder();
        SourceParameters sourceParameters = recorder.getParameters(additionalParameters);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("End parameters recording. Parameters=" + sourceParameters));
        }
        return sourceParameters;
    }

    public SourceParameters endParametersRecording(SourceParameters additionalParameters) throws SAXException {
        this.sendEndPrefixMapping();
        ParametersRecorder recorder = (ParametersRecorder)this.removeRecorder();
        SourceParameters sourceParameters = recorder.getParameters(additionalParameters);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("End parameters recording. Parameters=" + sourceParameters));
        }
        return sourceParameters;
    }

    public void startRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Start recording");
        }
        DOMBuilder builder = new DOMBuilder(this.tfactory);
        this.addRecorder((XMLConsumer)builder);
        builder.startDocument();
        builder.startElement("", "cocoon", "cocoon", EMPTY_ATTRIBUTES);
        this.sendStartPrefixMapping();
    }

    public DocumentFragment endRecording() throws SAXException {
        this.sendEndPrefixMapping();
        DOMBuilder builder = (DOMBuilder)((Object)this.removeRecorder());
        builder.endElement("", "cocoon", "cocoon");
        builder.endDocument();
        Document doc = builder.getDocument();
        DocumentFragment fragment = doc.createDocumentFragment();
        Element root = doc.getDocumentElement();
        root.normalize();
        boolean space = true;
        while (root.hasChildNodes()) {
            Node child = root.getFirstChild();
            root.removeChild(child);
            if (space && child.getNodeType() == 3 && child.getNodeValue().trim().length() == 0) continue;
            space = false;
            fragment.appendChild(child);
        }
        if (this.getLogger().isDebugEnabled()) {
            Object serializedXML;
            try {
                serializedXML = fragment == null ? "null" : XMLUtils.serializeNode(fragment);
            }
            catch (ProcessingException ignore) {
                serializedXML = fragment;
            }
            this.getLogger().debug((Object)("End recording. Fragment=" + serializedXML));
        }
        return fragment;
    }

    public void setupTransforming() throws IOException, ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"setupTransforming");
        }
        this.stack.clear();
        this.recorderStack.clear();
        this.ignoreWhitespaces = true;
        this.ignoreEmptyCharacters = false;
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endElement(uri, name, raw);
        }
    }

    public void sendTextEvent(String text) throws SAXException {
        this.characters(text.toCharArray(), 0, text.length());
    }

    public void sendStartElementEvent(String localname) throws SAXException {
        this.startElement("", localname, localname, EMPTY_ATTRIBUTES);
    }

    public void sendStartElementEventNS(String localname) throws SAXException {
        this.startElement(this.namespaceURI, localname, this.ourPrefix + ':' + localname, EMPTY_ATTRIBUTES);
    }

    public void sendStartElementEvent(String localname, Attributes attr) throws SAXException {
        this.startElement("", localname, localname, attr);
    }

    public void sendStartElementEventNS(String localname, Attributes attr) throws SAXException {
        this.startElement(this.namespaceURI, localname, this.ourPrefix + ':' + localname, attr);
    }

    public void sendEndElementEvent(String localname) throws SAXException {
        this.endElement("", localname, localname);
    }

    public void sendEndElementEventNS(String localname) throws SAXException {
        this.endElement(this.namespaceURI, localname, this.ourPrefix + ':' + localname);
    }

    public void sendEvents(Node node) throws SAXException {
        IncludeXMLConsumer.includeNode(node, (ContentHandler)((Object)this), (LexicalHandler)((Object)this));
    }

    public void sendParametersEvents(SourceParameters pars) throws SAXException {
        if (pars != null) {
            Iterator names = pars.getParameterNames();
            while (names.hasNext()) {
                String currentName = (String)names.next();
                Iterator values = pars.getParameterValues(currentName);
                while (values.hasNext()) {
                    String currentValue = (String)values.next();
                    this.sendStartElementEvent(currentName);
                    this.sendTextEvent(currentValue);
                    this.sendEndElementEvent(currentName);
                }
            }
        }
    }

    protected void sendStartPrefixMapping() throws SAXException {
        int l = this.namespaces.size();
        for (int i = 0; i < l; ++i) {
            String[] prefixAndUri = (String[])this.namespaces.get(i);
            this.contentHandler.startPrefixMapping(prefixAndUri[0], prefixAndUri[1]);
        }
    }

    protected void sendEndPrefixMapping() throws SAXException {
        int l = this.namespaces.size();
        for (int i = 0; i < l; ++i) {
            String[] prefixAndUri = (String[])this.namespaces.get(i);
            this.contentHandler.endPrefixMapping(prefixAndUri[0]);
        }
    }

    protected String findPrefixMapping(String uri) {
        int l = this.namespaces.size();
        for (int i = 0; i < l; ++i) {
            String[] prefixAndUri = (String[])this.namespaces.get(i);
            if (!prefixAndUri[1].equals(uri)) continue;
            return prefixAndUri[0];
        }
        return null;
    }

    protected AttributesImpl getMutableAttributes(Attributes a) {
        if (a instanceof AttributesImpl && !(a instanceof ImmutableAttributesImpl)) {
            return (AttributesImpl)a;
        }
        return new AttributesImpl(a);
    }
}

