/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.ValueHolder;
import org.apache.cocoon.environment.http.HttpCookie;
import org.apache.cocoon.environment.http.HttpEnvironment;
import org.apache.cocoon.environment.http.HttpSession;
import org.apache.cocoon.environment.http.RequestEncodingException;
import org.apache.cocoon.environment.impl.AbstractRequest;
import org.apache.commons.collections.IteratorUtils;

public final class HttpRequest
extends AbstractRequest {
    private final HttpServletRequest req;
    private final HttpEnvironment env;
    private String form_encoding;
    private String container_encoding;
    private static final Map sessions = new WeakHashMap();
    private final Map attributes = new HashMap();
    private Cookie[] wrappedCookies = null;
    private Map wrappedCookieMap = null;
    private Map cookieMap = null;
    protected String reqURI;

    protected HttpRequest(HttpServletRequest req, HttpEnvironment env) {
        this.req = req;
        this.env = env;
    }

    public Object get(String name) {
        if (this.req instanceof ValueHolder) {
            return ((ValueHolder)this.req).get(name);
        }
        String[] values = this.req.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        if (values.length > 1) {
            Vector<String> vect = new Vector<String>(values.length);
            for (int i = 0; i < values.length; ++i) {
                vect.add(values[i]);
            }
            return vect;
        }
        return null;
    }

    public String getAuthType() {
        return this.req.getAuthType();
    }

    public javax.servlet.http.Cookie[] getCookies() {
        return this.req.getCookies();
    }

    public Map getCookieMap() {
        if (this.cookieMap == null) {
            this.createCookieMap();
        }
        return this.cookieMap;
    }

    private synchronized void createCookieMap() {
        HashMap<String, javax.servlet.http.Cookie> cookieMap = new HashMap<String, javax.servlet.http.Cookie>();
        javax.servlet.http.Cookie[] cookies = this.req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                javax.servlet.http.Cookie cookie = cookies[i];
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        this.cookieMap = Collections.unmodifiableMap(cookieMap);
    }

    public Cookie[] getCocoonCookies() {
        if (this.wrappedCookieMap == null) {
            this.wrapCookies();
        }
        return this.wrappedCookies;
    }

    public Map getCocoonCookieMap() {
        if (this.wrappedCookieMap == null) {
            this.wrapCookies();
        }
        return this.wrappedCookieMap;
    }

    private synchronized void wrapCookies() {
        this.wrappedCookieMap = new HashMap();
        javax.servlet.http.Cookie[] cookies = this.req.getCookies();
        if (cookies != null) {
            this.wrappedCookies = new Cookie[cookies.length];
            for (int i = 0; i < cookies.length; ++i) {
                HttpCookie cookie = new HttpCookie(cookies[i]);
                this.wrappedCookies[i] = cookie;
                this.wrappedCookieMap.put(cookie.getName(), cookie);
            }
        }
        this.wrappedCookieMap = Collections.unmodifiableMap(this.wrappedCookieMap);
    }

    public long getDateHeader(String name) {
        return this.req.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.req.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this.req.getHeaderNames();
    }

    @Override
    public int getIntHeader(String name) {
        return this.req.getIntHeader(name);
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    public String getContextPath() {
        return this.req.getContextPath();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.req.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.req.getRequestedSessionId();
    }

    public String getRequestURI() {
        if (this.reqURI == null) {
            this.reqURI = this.req.getRequestURI();
            if (this.reqURI.equals("/")) {
                String s = this.req.getServletPath();
                StringBuffer buffer = new StringBuffer();
                if (null != s) {
                    buffer.append(s);
                }
                if (null != (s = this.req.getPathInfo())) {
                    buffer.append(s);
                }
                this.reqURI = buffer.toString();
            }
        }
        return this.reqURI;
    }

    public String getSitemapURI() {
        return this.env.getURI();
    }

    public String getSitemapURIPrefix() {
        return this.env.getURIPrefix();
    }

    public String getSitemapPath() {
        return this.env.getURIPrefix();
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.servlet.http.HttpSession getSession(boolean create) {
        HttpSession session;
        javax.servlet.http.HttpSession serverSession = this.req.getSession(create);
        if (serverSession != null) {
            Map map = sessions;
            synchronized (map) {
                WeakReference ref = (WeakReference)sessions.get(serverSession);
                if (ref == null || (session = (HttpSession)ref.get()) == null) {
                    session = new HttpSession(serverSession);
                    sessions.put(serverSession, new WeakReference<HttpSession>(session));
                }
            }
        } else {
            session = null;
        }
        return session;
    }

    public javax.servlet.http.HttpSession getSession() {
        return this.getSession(true);
    }

    public Session getCocoonSession(boolean create) {
        return (Session)this.getSession(true);
    }

    public Session getCocoonSession() {
        return (Session)this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        return this.req.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.req.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.req.isRequestedSessionIdFromURL();
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return this.req.isRequestedSessionIdFromURL();
    }

    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.req.getAttributeNames();
    }

    public void setAttribute(String name, Object value) {
        this.req.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.req.removeAttribute(name);
    }

    public Object getLocalAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getLocalAttributeNames() {
        return IteratorUtils.asEnumeration(this.attributes.keySet().iterator());
    }

    public void setLocalAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeLocalAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getCharacterEncoding() {
        if (this.form_encoding == null) {
            return this.req.getCharacterEncoding();
        }
        return this.form_encoding;
    }

    public void setCharacterEncoding(String form_encoding) throws UnsupportedEncodingException {
        this.form_encoding = form_encoding;
    }

    public void setContainerEncoding(String container_encoding) {
        this.container_encoding = container_encoding;
    }

    public int getContentLength() {
        return this.req.getContentLength();
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.req.getInputStream();
    }

    public String getParameter(String name) {
        String value = this.req.getParameter(name);
        if (this.form_encoding == null || this.container_encoding == null || value == null) {
            return value;
        }
        if (this.container_encoding.equals(this.form_encoding)) {
            return value;
        }
        return this.decode(value);
    }

    private String decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            if (this.container_encoding == null) {
                this.container_encoding = "ISO-8859-1";
            }
            byte[] bytes = str.getBytes(this.container_encoding);
            return new String(bytes, this.form_encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RequestEncodingException("Unsupported Encoding Exception", uee);
        }
    }

    public Enumeration getParameterNames() {
        return this.req.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        String[] values = this.req.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (this.form_encoding == null) {
            return values;
        }
        String[] decoded_values = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            decoded_values[i] = this.decode(values[i]);
        }
        return decoded_values;
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public String getScheme() {
        return this.req.getScheme();
    }

    public String getServerName() {
        return this.req.getServerName();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return this.req.getReader();
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    public Locale getLocale() {
        return this.req.getLocale();
    }

    public Enumeration getLocales() {
        return this.req.getLocales();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return this.req.getRequestDispatcher(path);
    }

    @Override
    public String getRealPath(String path) {
        return this.req.getRealPath(path);
    }

    public Object searchAttribute(String name) {
        Object result = this.getLocalAttribute(name);
        if (result == null) {
            result = this.getAttribute(name);
        }
        return result;
    }
}

