/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.http;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.http.HttpRequest;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.util.NetUtils;

public class HttpEnvironment
extends AbstractEnvironment {
    public static final String HTTP_REQUEST_OBJECT = "httprequest";
    public static final String HTTP_RESPONSE_OBJECT = "httpresponse";
    public static final String HTTP_SERVLET_CONTEXT = "httpservletcontext";
    private HttpRequest request;
    private HttpResponse response;
    private String contentType;

    public HttpEnvironment(String uri, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext, Context context, String containerEncoding, String defaultFormEncoding) throws IOException {
        super(uri, null, null);
        this.request = new HttpRequest(req, this);
        this.request.setCharacterEncoding(defaultFormEncoding);
        this.request.setContainerEncoding(containerEncoding);
        this.response = new HttpResponse(res);
        this.setView(HttpEnvironment.extractView(this.request));
        this.setAction(HttpEnvironment.extractAction(this.request));
        this.objectModel.put("request", this.request);
        this.objectModel.put("response", this.response);
        this.objectModel.put("context", context);
        this.objectModel.put(HTTP_REQUEST_OBJECT, req);
        this.objectModel.put(HTTP_RESPONSE_OBJECT, res);
        this.objectModel.put(HTTP_SERVLET_CONTEXT, servletContext);
    }

    public void redirect(String newURL, boolean global, boolean permanent) throws IOException {
        String redirect = this.response.encodeRedirectURL(newURL);
        if (!newURL.startsWith("/") && newURL.indexOf(58) == -1 && redirect.indexOf(58) != -1) {
            String base;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Redirect: WebSphere Bug Detected!");
            }
            if ((base = NetUtils.getPath((String)this.request.getRequestURI())).startsWith("/")) {
                base = base.substring(1);
            }
            redirect = this.response.encodeRedirectURL(base + '/' + newURL);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Sending redirect to '" + redirect + "'"));
        }
        if (permanent) {
            this.response.sendPermanentRedirect(redirect);
        } else {
            this.response.sendRedirect(redirect);
        }
    }

    @Override
    public void setStatus(int statusCode) {
        this.response.setStatus(statusCode);
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentLength(int length) {
        this.response.setContentLength(length);
    }

    @Override
    public boolean isResponseModified(long lastModified) {
        if (lastModified != 0L) {
            long if_modified_since = this.request.getDateHeader("If-Modified-Since");
            this.response.setDateHeader("Last-Modified", lastModified);
            return if_modified_since / 1000L < lastModified / 1000L;
        }
        return true;
    }

    @Override
    public void setResponseIsNotModified() {
        this.response.setStatus(304);
    }

    @Override
    public boolean tryResetResponse() throws IOException {
        if (!super.tryResetResponse()) {
            try {
                if (!this.response.isCommitted()) {
                    this.response.reset();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"Response successfully reset");
                    }
                    return true;
                }
            }
            catch (Exception e) {
                this.getLogger().warn((Object)"Problem resetting response", (Throwable)e);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Response wasn't reset");
            }
            return false;
        }
        return true;
    }

    @Override
    public OutputStream getOutputStream(int bufferSize) throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.response.getOutputStream();
        }
        return super.getOutputStream(bufferSize);
    }

    public boolean isExternal() {
        return true;
    }
}

