/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.http;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.apache.cocoon.environment.http.ContextURLException;
import org.apache.cocoon.environment.impl.AbstractContext;

public final class HttpContext
extends AbstractContext {
    private final ServletContext servletContext;

    public HttpContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public Object getAttribute(String name) {
        return this.servletContext.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.servletContext.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.servletContext.removeAttribute(name);
    }

    @Override
    public Enumeration getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        return this.servletContext.getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    @Override
    public String getRealPath(String path) {
        if (path.equals("/")) {
            String value = this.servletContext.getRealPath(path);
            if (value == null) {
                try {
                    URL webXml = this.servletContext.getResource("/WEB-INF/web.xml");
                    if (webXml == null) {
                        return null;
                    }
                    value = webXml.toString();
                }
                catch (MalformedURLException mue) {
                    throw new ContextURLException("Cannot determine the base URL for " + path, mue);
                }
                value = value.substring(0, value.length() - "WEB-INF/web.xml".length());
            }
            return value;
        }
        return this.servletContext.getRealPath(path);
    }

    @Override
    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    @Override
    public String getInitParameter(String name) {
        return this.servletContext.getInitParameter(name);
    }

    @Override
    public ServletContext getContext(String uripath) {
        return this.servletContext.getContext(uripath);
    }

    @Override
    public Enumeration getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    @Override
    public int getMajorVersion() {
        return this.servletContext.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.servletContext.getMinorVersion();
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        return this.servletContext.getNamedDispatcher(name);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return this.servletContext.getRequestDispatcher(path);
    }

    @Override
    public String getServerInfo() {
        return this.servletContext.getServerInfo();
    }

    public void log(String msg) {
        this.servletContext.log(msg);
    }

    public void log(String msg, Throwable throwable) {
        this.servletContext.log(msg, throwable);
    }

    public void log(Exception exception, String msg) {
        this.servletContext.log(msg, (Throwable)exception);
    }
}

