/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.reading.Reader;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.transformation.Transformer;

public class PipelineComponentInfo {
    public static final String ROLE = PipelineComponentInfo.class.getName();
    protected static final String GENERATOR_PREFIX = Generator.ROLE + "/";
    protected static final String TRANSFORMER_PREFIX = Transformer.ROLE + "/";
    protected static final String SERIALIZER_PREFIX = Serializer.ROLE + "/";
    protected static final String READER_PREFIX = Reader.ROLE + "/";
    protected PipelineComponentInfo parent;
    protected boolean locked = false;
    private Map data;

    public PipelineComponentInfo(PipelineComponentInfo parent) {
        this.parent = parent;
    }

    public void componentAdded(String role, String clazz, Configuration config) {
        if (role.startsWith(GENERATOR_PREFIX)) {
            this.setupLabelAndPipelineHint(role, config);
        } else if (role.startsWith(TRANSFORMER_PREFIX)) {
            this.setupLabelAndPipelineHint(role, config);
        } else if (role.startsWith(SERIALIZER_PREFIX)) {
            this.setupLabelAndPipelineHint(role, config);
            this.setupMimeType(role, config);
        } else if (role.startsWith(READER_PREFIX)) {
            this.setupMimeType(role, config);
        }
    }

    protected void setupLabelAndPipelineHint(String role, Configuration config) {
        String label = config.getAttribute("label", null);
        if (label != null) {
            StringTokenizer st = new StringTokenizer(label, " ,", false);
            String[] labels = new String[st.countTokens()];
            for (int tokenIdx = 0; tokenIdx < labels.length; ++tokenIdx) {
                labels[tokenIdx] = st.nextToken();
            }
            this.setLabels(role, labels);
        } else {
            this.setLabels(role, null);
        }
        String pipelineHint = config.getAttribute("hint", null);
        this.setPipelineHint(role, pipelineHint);
    }

    protected void setupMimeType(String role, Configuration config) {
        this.setMimeType(role, config.getAttribute("mime-type", null));
    }

    private void setData(String key, Object value) {
        if (this.locked) {
            throw new IllegalStateException("ProcessorComponentInfo is locked");
        }
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, value);
    }

    private Object getData(String key) {
        if (this.data != null && this.data.containsKey(key)) {
            return this.data.get(key);
        }
        if (this.parent != null) {
            return this.parent.getData(key);
        }
        return null;
    }

    public void lock() {
        this.locked = true;
    }

    public void setDefaultType(String role, String hint) {
        this.setData("defaultType/" + role, hint);
    }

    public String getDefaultType(String role) {
        return (String)this.getData("defaultType/" + role);
    }

    public void setPipelineHint(String role, String hint) {
        this.setData("pipelineHint/" + role, hint);
    }

    public String getPipelineHint(String role, String type) {
        return (String)this.getData("pipelineHint/" + role + "/" + type);
    }

    public void setMimeType(String role, String mimeType) {
        this.setData("mimeType/" + role, mimeType);
    }

    public String getMimeType(String role, String type) {
        return (String)this.getData("mimeType/" + role + "/" + type);
    }

    public void setLabels(String role, String[] labels) {
        this.setData("labels/" + role, labels);
    }

    public String[] getLabels(String role, String type) {
        return (String[])this.getData("labels/" + role + "/" + type);
    }

    public boolean hasLabel(String role, String type, String label) {
        String[] labels = this.getLabels(role, type);
        if (labels != null) {
            for (int i = 0; i < labels.length; ++i) {
                if (!labels[i].equals(label)) continue;
                return true;
            }
        }
        return false;
    }

    public Map getData() {
        return this.data;
    }

    public void setData(Map map) {
        this.data = map;
    }

    public void addData(Map map) {
        if (this.data == null) {
            this.data = map;
        } else {
            this.data.putAll(map);
        }
    }
}

