/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.reading.Reader;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.sitemap.DisposableSitemapComponent;
import org.apache.cocoon.sitemap.SitemapErrorHandler;
import org.apache.cocoon.sitemap.SitemapModelComponent;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.util.location.Locatable;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractProcessingPipeline
extends AbstractLogEnabled
implements ProcessingPipeline,
Parameterizable,
Recyclable,
Serviceable {
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 0x100000;
    protected Generator generator;
    protected Parameters generatorParam;
    protected String generatorSource;
    protected ArrayList transformers = new ArrayList();
    protected ArrayList transformerParams = new ArrayList();
    protected ArrayList transformerSources = new ArrayList();
    protected Serializer serializer;
    protected Parameters serializerParam;
    protected String serializerSource;
    protected String serializerMimeType;
    protected Reader reader;
    protected Parameters readerParam;
    protected String readerSource;
    protected String readerMimeType;
    private SitemapErrorHandler errorHandler;
    private ProcessingPipeline errorPipeline;
    private boolean prepared;
    protected XMLConsumer lastConsumer;
    protected ServiceManager manager;
    protected ServiceManager newManager;
    protected Parameters configuration;
    protected long configuredExpires;
    protected int configuredOutputBufferSize;
    protected Parameters parameters;
    protected long expires;
    protected int outputBufferSize;
    protected SourceResolver sourceResolver;

    public void service(ServiceManager aManager) throws ServiceException {
        this.manager = aManager;
        this.newManager = aManager;
    }

    public void setProcessorManager(ServiceManager manager) {
        this.newManager = manager;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.configuration = params;
        String expiresValue = params.getParameter("expires", null);
        if (expiresValue != null) {
            this.configuredExpires = this.parseExpires(expiresValue);
        }
        this.configuredOutputBufferSize = params.getParameterAsInteger("outputBufferSize", 0x100000);
    }

    public void setup(Parameters params) {
        this.parameters = params;
        String expiresValue = params.getParameter("expires", null);
        this.expires = expiresValue != null ? this.parseExpires(expiresValue) : this.configuredExpires;
        this.outputBufferSize = params.getParameterAsInteger("outputBufferSize", this.configuredOutputBufferSize);
    }

    public void informBranchPoint() {
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        if (this.generator != null) {
            throw new ProcessingException("Generator already set. Cannot set generator '" + role + "'", this.getLocation(param));
        }
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot set generator '" + role + "'", this.getLocation(param));
        }
        try {
            this.generator = (Generator)this.newManager.lookup(Generator.ROLE + '/' + role);
        }
        catch (ServiceException ce) {
            throw ProcessingException.throwLocated((String)("Lookup of generator '" + role + "' failed"), (Throwable)ce, (Location)this.getLocation(param));
        }
        this.generatorSource = source;
        this.generatorParam = param;
    }

    public void addTransformer(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot add transformer '" + role + "'", this.getLocation(param));
        }
        if (this.generator == null) {
            throw new ProcessingException("Must set a generator before adding transformer '" + role + "'", this.getLocation(param));
        }
        try {
            this.transformers.add(this.newManager.lookup(Transformer.ROLE + '/' + role));
        }
        catch (ServiceException ce) {
            throw ProcessingException.throwLocated((String)("Lookup of transformer '" + role + "' failed"), (Throwable)ce, (Location)this.getLocation(param));
        }
        this.transformerSources.add(source);
        this.transformerParams.add(param);
    }

    public void setSerializer(String role, String source, Parameters param, Parameters hintParam, String mimeType) throws ProcessingException {
        if (this.serializer != null) {
            throw new ProcessingException("Serializer already set. Cannot set serializer '" + role + "'", this.getLocation(param));
        }
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot set serializer '" + role + "'", this.getLocation(param));
        }
        if (this.generator == null) {
            throw new ProcessingException("Must set a generator before setting serializer '" + role + "'", this.getLocation(param));
        }
        try {
            this.serializer = (Serializer)this.newManager.lookup(Serializer.ROLE + '/' + role);
        }
        catch (ServiceException ce) {
            throw ProcessingException.throwLocated((String)("Lookup of serializer '" + role + "' failed"), (Throwable)ce, (Location)this.getLocation(param));
        }
        this.serializerSource = source;
        this.serializerParam = param;
        this.serializerMimeType = mimeType;
        this.lastConsumer = this.serializer;
    }

    public void setReader(String role, String source, Parameters param, String mimeType) throws ProcessingException {
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot set reader '" + role + "'", this.getLocation(param));
        }
        if (this.generator != null) {
            throw new ProcessingException("Generator already set. Cannot use reader '" + role + "'", this.getLocation(param));
        }
        try {
            this.reader = (Reader)this.newManager.lookup(Reader.ROLE + '/' + role);
        }
        catch (ServiceException ce) {
            throw ProcessingException.throwLocated((String)("Lookup of reader '" + role + "' failed"), (Throwable)ce, (Location)this.getLocation(param));
        }
        this.readerSource = source;
        this.readerParam = param;
        this.readerMimeType = mimeType;
    }

    public void setErrorHandler(SitemapErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected boolean checkPipeline() {
        if (this.generator == null && this.reader == null) {
            return false;
        }
        return this.generator == null || this.serializer != null;
    }

    protected void setupPipeline(Environment environment) throws ProcessingException {
        try {
            this.generator.setup(this.sourceResolver, environment.getObjectModel(), this.generatorSource, this.generatorParam);
            Iterator transformerItt = this.transformers.iterator();
            Iterator transformerSourceItt = this.transformerSources.iterator();
            Iterator transformerParamItt = this.transformerParams.iterator();
            while (transformerItt.hasNext()) {
                Transformer trans = (Transformer)transformerItt.next();
                trans.setup(this.sourceResolver, environment.getObjectModel(), (String)transformerSourceItt.next(), (Parameters)transformerParamItt.next());
            }
            if (this.serializer instanceof SitemapModelComponent) {
                ((SitemapModelComponent)this.serializer).setup(this.sourceResolver, environment.getObjectModel(), this.serializerSource, this.serializerParam);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void connect(Environment environment, XMLProducer producer, XMLConsumer consumer) throws ProcessingException {
        producer.setConsumer(consumer);
    }

    protected void connectPipeline(Environment environment) throws ProcessingException {
        Generator prev = this.generator;
        for (Transformer next : this.transformers) {
            this.connect(environment, (XMLProducer)prev, (XMLConsumer)next);
            prev = next;
        }
        this.connect(environment, (XMLProducer)prev, this.lastConsumer);
    }

    public boolean process(Environment environment) throws ProcessingException {
        if (!this.prepared) {
            this.preparePipeline(environment);
        }
        if (this.expires != 0L) {
            Response res = ObjectModelHelper.getResponse((Map)environment.getObjectModel());
            res.setDateHeader("Expires", System.currentTimeMillis() + this.expires);
            res.setHeader("Cache-Control", "max-age=" + this.expires / 1000L + ", public");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Setting a new Expires object for this resource");
            }
            environment.getObjectModel().put("expires", new Long(this.expires + System.currentTimeMillis()));
        }
        if (this.reader != null) {
            if (this.checkIfModified(environment, this.reader.getLastModified())) {
                return true;
            }
            return this.processReader(environment);
        }
        if (this.lastConsumer == null) {
            this.lastConsumer = this.serializer;
        }
        this.connectPipeline(environment);
        return this.processXMLPipeline(environment);
    }

    protected void preparePipeline(Environment environment) throws ProcessingException {
        try {
            this.sourceResolver = (SourceResolver)this.newManager.lookup(SourceResolver.ROLE);
        }
        catch (ServiceException e) {
            throw new ProcessingException("Couldn't find a source resolver", (Throwable)e);
        }
        if (!this.checkPipeline()) {
            throw new ProcessingException("Attempted to process incomplete pipeline.");
        }
        if (this.prepared) {
            throw new ProcessingException("Duplicate preparePipeline call caught.");
        }
        if (this.reader != null) {
            this.setupReader(environment);
        } else {
            this.setupPipeline(environment);
        }
        this.prepared = true;
    }

    public void prepareInternal(Environment environment) throws ProcessingException {
        this.lastConsumer = null;
        try {
            this.preparePipeline(environment);
        }
        catch (ProcessingException e) {
            this.prepareInternalErrorHandler(environment, e);
        }
    }

    protected void prepareInternalErrorHandler(Environment environment, ProcessingException ex) throws ProcessingException {
        if (this.errorHandler == null) {
            throw ex;
        }
        try {
            this.errorPipeline = this.errorHandler.prepareErrorPipeline((Exception)((Object)ex));
            if (this.errorPipeline != null) {
                this.errorPipeline.prepareInternal(environment);
            }
        }
        catch (ProcessingException e) {
            this.getLogger().error((Object)"Failed to process error handler for exception", (Throwable)ex);
            throw e;
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Failed to process error handler for exception", (Throwable)ex);
            throw new ProcessingException("Failed to handle exception <" + ex.getMessage() + ">", (Throwable)e);
        }
    }

    protected boolean isInternalError() {
        return this.errorPipeline != null;
    }

    protected boolean processXMLPipeline(Environment environment) throws ProcessingException {
        this.setMimeTypeForSerializer(environment);
        try {
            if (this.lastConsumer == null) {
                this.generator.generate();
            } else if (this.serializer.shouldSetContentLength()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.serializer.setOutputStream((OutputStream)os);
                this.generator.generate();
                environment.setContentLength(os.size());
                os.writeTo(environment.getOutputStream(0));
            } else {
                this.serializer.setOutputStream(environment.getOutputStream(this.outputBufferSize));
                this.generator.generate();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return true;
    }

    protected void setupReader(Environment environment) throws ProcessingException {
        try {
            this.reader.setup(this.sourceResolver, environment.getObjectModel(), this.readerSource, this.readerParam);
            if (this.readerParam.isParameter("expires")) {
                this.expires = this.readerParam.getParameterAsLong("expires");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void setMimeTypeForReader(Environment environment) {
        if (this.readerMimeType != null) {
            environment.setContentType(this.readerMimeType);
        } else {
            String mimeType = this.reader.getMimeType();
            if (mimeType != null) {
                environment.setContentType(mimeType);
            }
        }
    }

    protected void setMimeTypeForSerializer(Environment environment) throws ProcessingException {
        if (this.lastConsumer == null) {
            environment.setContentType("text/xml");
        } else if (this.serializerMimeType != null) {
            environment.setContentType(this.serializerMimeType);
        } else {
            String mimeType = this.serializer.getMimeType();
            if (mimeType != null) {
                environment.setContentType(mimeType);
            } else {
                String message = "Unable to determine MIME type for " + environment.getURIPrefix() + "/" + environment.getURI();
                throw new ProcessingException(message);
            }
        }
    }

    protected boolean checkIfModified(Environment environment, long lastModified) throws ProcessingException {
        if (!environment.isResponseModified(lastModified)) {
            environment.setResponseIsNotModified();
            return true;
        }
        return false;
    }

    protected boolean processReader(Environment environment) throws ProcessingException {
        block7: {
            try {
                this.setMimeTypeForReader(environment);
                if (this.reader.shouldSetContentLength()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try {
                        this.reader.setOutputStream((OutputStream)os);
                        this.reader.generate();
                    }
                    catch (SourceException se) {
                        throw SourceUtil.handle(se);
                    }
                    environment.setContentLength(os.size());
                    os.writeTo(environment.getOutputStream(0));
                    break block7;
                }
                try {
                    this.reader.setOutputStream(environment.getOutputStream(this.outputBufferSize));
                    this.reader.generate();
                }
                catch (SourceException se) {
                    throw SourceUtil.handle(se);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return true;
    }

    public void recycle() {
        this.prepared = false;
        if (this.reader != null) {
            if (this.reader instanceof DisposableSitemapComponent) {
                ((DisposableSitemapComponent)this.reader).dispose();
            }
            this.newManager.release((Object)this.reader);
            this.reader = null;
            this.readerParam = null;
        }
        if (this.generator != null) {
            if (this.generator instanceof DisposableSitemapComponent) {
                ((DisposableSitemapComponent)this.generator).dispose();
            }
            this.newManager.release((Object)this.generator);
            this.generator = null;
            this.generatorParam = null;
        }
        int size = this.transformers.size();
        for (int i = 0; i < size; ++i) {
            if (this.transformers.get(i) instanceof DisposableSitemapComponent) {
                ((DisposableSitemapComponent)this.transformers.get(i)).dispose();
            }
            this.newManager.release(this.transformers.get(i));
        }
        this.transformers.clear();
        this.transformerParams.clear();
        this.transformerSources.clear();
        if (this.serializer != null) {
            if (this.serializer instanceof DisposableSitemapComponent) {
                ((DisposableSitemapComponent)this.serializer).dispose();
            }
            this.newManager.release((Object)this.serializer);
            this.serializerParam = null;
        }
        if (this.sourceResolver != null) {
            this.newManager.release((Object)this.sourceResolver);
        }
        this.serializer = null;
        this.parameters = null;
        this.sourceResolver = null;
        this.lastConsumer = null;
        this.errorHandler = null;
        this.errorPipeline = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Environment environment, XMLConsumer consumer) throws ProcessingException {
        XMLConsumer xMLConsumer;
        if (this.reader != null) {
            throw new ProcessingException("Streaming of an internal pipeline is not possible with a reader.");
        }
        if (this.errorPipeline != null) {
            return this.errorPipeline.process(environment, consumer);
        }
        SaxBuffer buffer = null;
        if (this.errorHandler == null) {
            xMLConsumer = consumer;
        } else {
            buffer = new SaxBuffer();
            xMLConsumer = buffer;
        }
        this.lastConsumer = xMLConsumer;
        try {
            this.connectPipeline(environment);
            boolean bl = this.processXMLPipeline(environment);
            return bl;
        }
        catch (ProcessingException e) {
            buffer = null;
            boolean bl = this.processErrorHandler(environment, e, consumer);
            return bl;
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.toSAX((ContentHandler)consumer);
                }
                catch (SAXException e) {
                    throw new ProcessingException("Failed to execute pipeline.", (Throwable)e);
                }
            }
        }
    }

    protected boolean processErrorHandler(Environment environment, ProcessingException e, XMLConsumer consumer) throws ProcessingException {
        if (this.errorHandler != null) {
            try {
                this.errorPipeline = this.errorHandler.prepareErrorPipeline((Exception)((Object)e));
                if (this.errorPipeline != null) {
                    this.errorPipeline.prepareInternal(environment);
                    return this.errorPipeline.process(environment, consumer);
                }
            }
            catch (Exception ignored) {
                this.getLogger().debug((Object)"Exception in error handler", (Throwable)ignored);
            }
        }
        throw e;
    }

    public SourceValidity getValidityForEventPipeline() {
        return null;
    }

    public String getKeyForEventPipeline() {
        return null;
    }

    private long parseExpires(String expire) {
        StringTokenizer tokens = new StringTokenizer(expire);
        String current = tokens.nextToken();
        if (current.equals("modification")) {
            this.getLogger().warn((Object)"the \"modification\" keyword is not yet implemented. Assuming \"now\" as the base attribute");
            current = "now";
        }
        if (!current.equals("now") && !current.equals("access")) {
            this.getLogger().error((Object)"bad <base> attribute, Expires header will not be set");
            return -1L;
        }
        long expires = 0L;
        while (tokens.hasMoreTokens()) {
            long modifier;
            long number;
            current = tokens.nextToken();
            if (current.equals("plus")) {
                current = tokens.nextToken();
            }
            try {
                number = Long.parseLong(current);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().error((Object)"state violation: a number was expected here");
                return -1L;
            }
            try {
                current = tokens.nextToken();
            }
            catch (NoSuchElementException nsee) {
                this.getLogger().error((Object)"State violation: expecting a modifier but no one found: Expires header will not be set");
            }
            if (current.equals("years")) {
                modifier = 31536000000L;
            } else if (current.equals("months")) {
                modifier = 2592000000L;
            } else if (current.equals("weeks")) {
                modifier = 604800000L;
            } else if (current.equals("days")) {
                modifier = 86400000L;
            } else if (current.equals("hours")) {
                modifier = 3600000L;
            } else if (current.equals("minutes")) {
                modifier = 60000L;
            } else if (current.equals("seconds")) {
                modifier = 1000L;
            } else {
                this.getLogger().error((Object)("Bad modifier (" + current + "): ignoring expires configuration"));
                return -1L;
            }
            expires += number * modifier;
        }
        return expires;
    }

    protected Location getLocation(Parameters param) {
        Location location = null;
        if (param instanceof Locatable) {
            location = ((Locatable)param).getLocation();
        }
        if (location == null) {
            location = Location.UNKNOWN;
        }
        return location;
    }

    protected void handleException(Exception e) throws ProcessingException {
        if (e instanceof SocketException) {
            if (e.getMessage().indexOf("reset") > -1 || e.getMessage().indexOf("aborted") > -1 || e.getMessage().indexOf("Broken pipe") > -1 || e.getMessage().indexOf("connection abort") > -1) {
                throw new ConnectionResetException("Connection reset by peer", (Throwable)e);
            }
        } else if (e instanceof IOException) {
            if (e.getClass().getName().endsWith("ClientAbortException")) {
                throw new ConnectionResetException("Connection reset by peer", (Throwable)e);
            }
        } else if (e instanceof ConnectionResetException) {
            throw (ConnectionResetException)e;
        }
        if (this.reader == null) {
            ArrayList<Location> locations = new ArrayList<Location>(this.transformers.size() + 2);
            locations.add(this.getLocation(this.serializerParam));
            for (int i = this.transformerParams.size() - 1; i >= 0; --i) {
                locations.add(this.getLocation((Parameters)this.transformerParams.get(i)));
            }
            locations.add(this.getLocation(this.generatorParam));
            throw ProcessingException.throwLocated((String)"Failed to process pipeline", (Throwable)e, locations);
        }
        throw ProcessingException.throwLocated((String)"Failed to process reader", (Throwable)e, (Location)this.getLocation(this.readerParam));
    }
}

