/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WriteDOMSessionTransformer
extends AbstractTransformer {
    public static final String DOM_NAME = "dom-name";
    public static final String DOM_ROOT_ELEMENT = "dom-root-element";
    private boolean buildDom;
    private boolean setup;
    private HttpSession session;
    private DOMBuilder builder;
    private String DOMName;
    private String rootElement;
    private Map storedPrefixMap;

    public void recycle() {
        this.session = null;
        this.builder = null;
        this.buildDom = false;
        this.setup = false;
        super.recycle();
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.getLogger().debug((Object)"WriteSessionTransformer: setup");
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        this.session = request.getSession(false);
        if (this.session != null) {
            this.DOMName = parameters.getParameter(DOM_NAME, null);
            this.rootElement = parameters.getParameter(DOM_ROOT_ELEMENT, null);
            if (this.DOMName != null && this.rootElement != null) {
                this.getLogger().debug((Object)("WriteSessionTransformer: dom-name=" + this.DOMName + "; " + DOM_ROOT_ELEMENT + "=" + this.rootElement));
                this.setup = true;
                this.storedPrefixMap = new HashMap();
            } else {
                this.getLogger().error((Object)"WriteSessionTransformer: need dom-name and dom-root-element parameters");
            }
        } else {
            this.getLogger().error((Object)"WriteSessionTransformer: no session object");
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        if (this.buildDom) {
            this.builder.startPrefixMapping(prefix, uri);
        } else if (this.setup) {
            this.storePrefixMapping(prefix, uri);
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        if (this.setup && name.equalsIgnoreCase(this.rootElement)) {
            this.getLogger().debug((Object)"WriteSessionTransformer: start building DOM tree");
            this.buildDom = true;
            this.builder = new DOMBuilder();
            this.builder.startDocument();
            this.launchStoredMappings();
            this.builder.startElement(uri, name, raw, attributes);
        } else if (this.buildDom) {
            this.builder.startElement(uri, name, raw, attributes);
        }
        this.contentHandler.startElement(uri, name, raw, attributes);
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (this.setup && name.equalsIgnoreCase(this.rootElement)) {
            this.buildDom = false;
            this.builder.endElement(uri, name, raw);
            this.builder.endDocument();
            this.getLogger().debug((Object)"WriteSessionTransformer: putting DOM tree in session object");
            this.session.setAttribute(this.DOMName, (Object)this.builder.getDocument().getFirstChild());
            this.getLogger().debug((Object)"WriteSessionTransformer: DOM tree is in session object");
        } else if (this.buildDom) {
            this.builder.endElement(uri, name, raw);
        }
        this.contentHandler.endElement(uri, name, raw);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.buildDom) {
            this.builder.characters(c, start, len);
        }
        this.contentHandler.characters(c, start, len);
    }

    public void startCDATA() throws SAXException {
        if (this.buildDom) {
            this.builder.startCDATA();
        }
        this.lexicalHandler.startCDATA();
    }

    public void endCDATA() throws SAXException {
        if (this.buildDom) {
            this.builder.endCDATA();
        }
        this.lexicalHandler.endCDATA();
    }

    protected void storePrefixMapping(String prefix, String uri) {
        this.storedPrefixMap.put(prefix, uri);
    }

    protected void launchStoredMappings() throws SAXException {
        for (Map.Entry entry : this.storedPrefixMap.entrySet()) {
            String pre = (String)entry.getKey();
            String uri = (String)entry.getValue();
            this.getLogger().debug((Object)("WriteSessionTransformer: launching prefix mapping[ pre: " + pre + " uri: " + uri + " ]"));
            this.builder.startPrefixMapping(pre, uri);
        }
    }
}

