/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.util.ByteRange;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public class ResourceReader
extends AbstractReader
implements CacheableProcessingComponent,
Configurable {
    private static final boolean CONFIGURED_BYTE_RANGES_DEFAULT = true;
    private static final int CONFIGURED_BUFFER_SIZE_DEFAULT = 8192;
    private static final boolean CONFIGURED_QUICK_TEST_DEFAULT = false;
    private static final int CONFIGURED_EXPIRES_DEFAULT = -1;
    private static final Map documents = Collections.synchronizedMap(new HashMap());
    protected long configuredExpires = -1L;
    protected boolean configuredQuickTest = false;
    protected int configuredBufferSize = 8192;
    protected boolean configuredByteRanges = true;
    protected long expires;
    protected boolean quickTest;
    protected int bufferSize;
    protected boolean byteRanges;
    protected Response response;
    protected Request request;
    protected Source inputSource;

    public void setBufferSize(int bufferSize) {
        this.configuredBufferSize = bufferSize;
    }

    public void setByteRanges(boolean byteRanges) {
        this.configuredByteRanges = byteRanges;
    }

    public void setExpires(long expires) {
        this.configuredExpires = expires;
    }

    public void setQuickTest(boolean quickTest) {
        this.configuredQuickTest = quickTest;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Parameters parameters = Parameters.fromConfiguration((Configuration)configuration);
        this.setExpires(parameters.getParameterAsLong("expires", -1L));
        this.setQuickTest(parameters.getParameterAsBoolean("quick-modified-test", false));
        this.setBufferSize(parameters.getParameterAsInteger("buffer-size", 8192));
        this.setByteRanges(parameters.getParameterAsBoolean("byte-ranges", true));
        this.setExpires(configuration.getChild("expires").getValueAsLong(this.configuredExpires));
        this.setQuickTest(configuration.getChild("quick-modified-test").getValueAsBoolean(this.configuredQuickTest));
        this.setBufferSize(configuration.getChild("buffer-size").getValueAsInteger(this.configuredBufferSize));
        this.setByteRanges(configuration.getChild("byte-ranges").getValueAsBoolean(this.configuredByteRanges));
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
        this.response = ObjectModelHelper.getResponse((Map)objectModel);
        this.expires = par.getParameterAsLong("expires", this.configuredExpires);
        this.quickTest = par.getParameterAsBoolean("quick-modified-test", this.configuredQuickTest);
        this.bufferSize = par.getParameterAsInteger("buffer-size", this.configuredBufferSize);
        this.byteRanges = par.getParameterAsBoolean("byte-ranges", this.configuredByteRanges);
        try {
            this.inputSource = resolver.resolveURI(src);
        }
        catch (SourceException e) {
            throw SourceUtil.handle((String)("Error during resolving of '" + src + "'."), (SourceException)e);
        }
        this.setupHeaders();
    }

    protected void setupHeaders() {
        if (this.byteRanges) {
            this.response.setHeader("Accept-Ranges", "bytes");
        } else {
            this.response.setHeader("Accept-Ranges", "none");
        }
        if (this.expires > 0L) {
            this.response.setDateHeader("Expires", System.currentTimeMillis() + this.expires);
        } else if (this.expires == 0L) {
            this.response.setDateHeader("Expires", 0L);
        }
    }

    public void recycle() {
        this.request = null;
        this.response = null;
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        super.recycle();
    }

    protected boolean hasRanges() {
        return this.byteRanges && this.request.getHeader("Range") != null;
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public SourceValidity getValidity() {
        if (this.hasRanges()) {
            return null;
        }
        return this.inputSource.getValidity();
    }

    public long getLastModified() {
        if (this.hasRanges()) {
            return 0L;
        }
        if (this.quickTest) {
            return this.inputSource.getLastModified();
        }
        String systemId = (String)documents.get(this.request.getRequestURI());
        String sourceURI = this.inputSource.getURI();
        if (systemId == null || sourceURI != null && sourceURI.equals(systemId)) {
            return this.inputSource.getLastModified();
        }
        documents.remove(this.request.getRequestURI());
        return 0L;
    }

    protected void processStream(InputStream inputStream) throws IOException, ProcessingException {
        ByteRange byteRange;
        byte[] buffer = new byte[this.bufferSize];
        String ranges = this.request.getHeader("Range");
        if (this.byteRanges && ranges != null) {
            try {
                ranges = ranges.substring(ranges.indexOf(61) + 1);
                byteRange = new ByteRange(ranges);
            }
            catch (NumberFormatException e) {
                byteRange = null;
                if (this.response instanceof HttpResponse) {
                    this.response.setStatus(416);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("malformed byte range header [" + String.valueOf(ranges) + "]"));
                    }
                }
            }
        } else {
            byteRange = null;
        }
        long contentLength = this.inputSource.getContentLength();
        if (byteRange != null) {
            int length;
            String entityRange;
            String entityLength;
            if (contentLength != -1L) {
                entityLength = "" + contentLength;
                entityRange = byteRange.intersection(new ByteRange(0L, contentLength)).toString();
            } else {
                entityLength = "*";
                entityRange = byteRange.toString();
            }
            this.response.setHeader("Content-Range", entityRange + "/" + entityLength);
            if (this.response instanceof HttpResponse) {
                this.response.setStatus(206);
            }
            int pos = 0;
            while ((length = inputStream.read(buffer)) > -1) {
                int posEnd = pos + length - 1;
                ByteRange intersection = byteRange.intersection(new ByteRange((long)pos, (long)posEnd));
                if (intersection != null) {
                    this.out.write(buffer, (int)intersection.getStart() - pos, (int)intersection.length());
                }
                pos += length;
            }
        } else {
            int length;
            if (contentLength != -1L) {
                this.response.setHeader("Content-Length", Long.toString(contentLength));
            }
            while ((length = inputStream.read(buffer)) > -1) {
                this.out.write(buffer, 0, length);
            }
        }
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException, ProcessingException {
        InputStream inputStream;
        try {
            inputStream = this.inputSource.getInputStream();
        }
        catch (SourceException e) {
            throw SourceUtil.handle((String)"Error during resolving of the input stream", (SourceException)e);
        }
        try {
            this.processStream(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (!this.quickTest) {
            documents.put(this.request.getRequestURI(), this.inputSource.getURI());
        }
    }

    public String getMimeType() {
        String mimeType;
        Context ctx = ObjectModelHelper.getContext((Map)this.objectModel);
        if (ctx != null && (mimeType = ctx.getMimeType(this.source)) != null) {
            return mimeType;
        }
        return this.inputSource.getMimeType();
    }
}

