/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.core.xml.DOMParser;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.TraversableGenerator;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.commons.logging.Log;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPathTraversableGenerator
extends TraversableGenerator {
    protected static final String XPATH_NODE_NAME = "xpath";
    protected static final String QUERY_ATTR_NAME = "query";
    protected static final String RESULT_DOCID_ATTR = "docid";
    protected RE xmlRE;
    protected DOMParser parser;
    protected Document doc;
    protected String xpath;
    protected XPathProcessor processor;
    protected XPathPrefixResolver prefixResolver;
    protected Context context;

    public void setParser(DOMParser parser) {
        this.parser = parser;
    }

    public void setXPathProcessor(XPathProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        int pointer = this.source.indexOf("#");
        if (pointer != -1) {
            int endpointer = this.source.indexOf(63);
            this.xpath = endpointer != -1 ? this.source.substring(pointer + 1, endpointer) : this.source.substring(pointer + 1);
            this.source = src.substring(0, pointer);
            if (endpointer != -1) {
                this.source = this.source + src.substring(endpointer);
            }
        } else {
            this.xpath = par.getParameter(XPATH_NODE_NAME, null);
        }
        this.cacheKeyParList.add(this.xpath);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Applying XPath: " + this.xpath + " to collection " + this.source));
        }
        String xmlFilesPattern = null;
        try {
            xmlFilesPattern = par.getParameter("xmlFiles", "\\.xml$");
            this.cacheKeyParList.add(xmlFilesPattern);
            this.xmlRE = new RE(xmlFilesPattern);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("pattern for XML files: " + xmlFilesPattern));
            }
        }
        catch (RESyntaxException rese) {
            throw new ProcessingException("Syntax error in regexp pattern '" + xmlFilesPattern + "'", (Throwable)rese);
        }
        String[] params = par.getNames();
        this.prefixResolver = new XPathPrefixResolver(this.getLogger());
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].startsWith("xmlns:")) continue;
            String paramValue = par.getParameter(params[i], "");
            String paramName = params[i].substring(6);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("add param to prefixResolver: " + paramName));
            }
            this.prefixResolver.addPrefix(paramName, paramValue);
        }
        this.context = ObjectModelHelper.getContext((Map)objectModel);
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.processor = (XPathProcessor)manager.lookup(XPathProcessor.ROLE);
        this.parser = (DOMParser)manager.lookup(DOMParser.class.getName());
    }

    @Override
    public void recycle() {
        this.xpath = null;
        this.doc = null;
        this.xmlRE = null;
        this.prefixResolver = null;
        this.context = null;
        super.recycle();
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.processor);
            this.processor = null;
        }
        super.dispose();
    }

    @Override
    protected void addContent(TraversableSource source) throws SAXException, ProcessingException {
        super.addContent(source);
        if (!source.isCollection() && this.isXML(source) && this.xpath != null) {
            this.performXPathQuery(source);
        }
    }

    protected boolean isXML(TraversableSource path) {
        String mimeType = this.context.getMimeType(path.getName());
        return this.xmlRE.match(path.getName()) || "text/xml".equalsIgnoreCase(mimeType);
    }

    protected void performXPathQuery(TraversableSource in) throws SAXException {
        this.doc = null;
        try {
            this.doc = this.parser.parseDocument(SourceUtil.getInputSource((Source)in));
        }
        catch (SAXException se) {
            this.getLogger().error((Object)("Warning:" + in.getName() + " is not a valid XML document. Ignoring"));
        }
        catch (Exception e) {
            this.getLogger().error((Object)("Unable to resolve and parse document" + e));
        }
        if (this.doc != null) {
            NodeList nl = this.processor.selectNodeList((Node)this.doc.getDocumentElement(), this.xpath, (PrefixResolver)this.prefixResolver);
            String id = in.getName();
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", RESULT_DOCID_ATTR, RESULT_DOCID_ATTR, " CDATA", id);
            attributes.addAttribute("", QUERY_ATTR_NAME, QUERY_ATTR_NAME, "CDATA", this.xpath);
            this.contentHandler.startElement("http://apache.org/cocoon/collection/1.0", XPATH_NODE_NAME, "collection:xpath", attributes);
            DOMStreamer ds = new DOMStreamer(this.xmlConsumer);
            for (int i = 0; i < nl.getLength(); ++i) {
                ds.stream(nl.item(i));
            }
            this.contentHandler.endElement("http://apache.org/cocoon/collection/1.0", XPATH_NODE_NAME, "collection:xpath");
        }
    }

    class XPathPrefixResolver
    implements PrefixResolver {
        private final Log logger;
        private Map params = new HashMap();

        public XPathPrefixResolver(Log logger) {
            this.logger = logger;
        }

        public String prefixToNamespace(String prefix) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("prefix: " + prefix));
            }
            if (this.params.containsKey(prefix)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("prefix; " + prefix + " - namespace: " + this.params.get(prefix)));
                }
                return (String)this.params.get(prefix);
            }
            return null;
        }

        public void addPrefix(String prefix, String uri) {
            this.params.put(prefix, uri);
        }
    }
}

