/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.cocoon.generation.DirectoryGenerator;
import org.xml.sax.SAXException;

public class MP3DirectoryGenerator
extends DirectoryGenerator {
    private static final int VERSION_MPEG1 = 3;
    private static final int MODE_DUAL_CHANNEL = 2;
    private static final int MODE_JOINT_STEREO = 1;
    private static final int MODE_SINGLE_CHANNEL = 3;
    private static final int MODE_STEREO = 0;
    private static final int VBR_FRAMES_FLAG = 1;
    protected static final String MP3_FREQUENCY_ATTR_NAME = "frequency";
    protected static final String MP3_BITRATE_ATTR_NAME = "bitrate";
    protected static final String MP3_MODE_ATTR_NAME = "mode";
    protected static final String MP3_VBR_ATTR_NAME = "variable-rate";
    protected static final String MP3_TITLE_ATTR_NAME = "title";
    protected static final String MP3_ARTIST_ATTR_NAME = "artist";
    protected static final String MP3_ALBUM_ATTR_NAME = "album";
    protected static final String MP3_YEAR_ATTR_NAME = "year";
    protected static final String MP3_COMMENT_ATTR_NAME = "comment";
    protected static final String MP3_TRACK_ATTR_NAME = "track";
    protected static final String MP3_GENRE_ATTR_NAME = "genre";
    private static final String[][][] bitrates = new String[][][]{{{"free format", "32", "48", "56", "64", "80", "96", "112", "128", "144", "160", "176", "192", "224", "256", "forbidden"}, {"free format", "8", "16", "24", "32", "40", "48", "56", "64", "80", "96", "112", "128", "144", "160", "forbidden"}, {"free format", "8", "16", "24", "32", "40", "48", "56", "64", "80", "96", "112", "128", "144", "160", "forbidden"}}, {{"free format", "32", "64", "96", "128", "160", "192", "224", "256", "288", "320", "352", "384", "416", "448", "forbidden"}, {"free format", "32", "48", "56", "64", "80", "96", "112", "128", "160", "192", "224", "256", "320", "384", "forbidden"}, {"free format", "32", "40", "48", "56", "64", "80", "96", "112", "128", "160", "192", "224", "256", "320", "forbidden"}}};
    private static final int[][] frequencies = new int[][]{{32000, 16000, 8000}, {0, 0, 0}, {22050, 24000, 16000}, {44100, 48000, 32000}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setNodeAttributes(File path) throws SAXException {
        super.setNodeAttributes(path);
        if (path.isDirectory()) {
            return;
        }
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(path, "r");
            this.setID3HeaderAttributes(in);
            this.setID3TagAttributes(in);
        }
        catch (IOException e) {
            this.getLogger().debug((Object)("Could not set attributes for " + path), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setID3TagAttributes(RandomAccessFile in) throws IOException {
        if (in.length() < 128L) {
            return;
        }
        in.seek(in.length() - 128L);
        byte[] buf = new byte[128];
        if (in.read(buf, 0, 128) != 128) {
            return;
        }
        if (buf[0] != 84 || buf[1] != 65 || buf[2] != 71) {
            return;
        }
        String s = this.getID3TagValue(buf, 3, 30);
        if (s.length() > 0) {
            this.attributes.addAttribute("", MP3_TITLE_ATTR_NAME, MP3_TITLE_ATTR_NAME, "CDATA", s);
        }
        if ((s = this.getID3TagValue(buf, 33, 30)).length() > 0) {
            this.attributes.addAttribute("", MP3_ARTIST_ATTR_NAME, MP3_ARTIST_ATTR_NAME, "CDATA", s);
        }
        if ((s = this.getID3TagValue(buf, 63, 30)).length() > 0) {
            this.attributes.addAttribute("", MP3_ALBUM_ATTR_NAME, MP3_ALBUM_ATTR_NAME, "CDATA", s);
        }
        if ((s = this.getID3TagValue(buf, 93, 4)).length() > 0) {
            this.attributes.addAttribute("", MP3_YEAR_ATTR_NAME, MP3_YEAR_ATTR_NAME, "CDATA", s);
        }
        if ((s = this.getID3TagValue(buf, 97, 29)).length() > 0) {
            this.attributes.addAttribute("", MP3_COMMENT_ATTR_NAME, MP3_COMMENT_ATTR_NAME, "CDATA", s);
        }
        if (buf[126] > 0) {
            this.attributes.addAttribute("", MP3_TRACK_ATTR_NAME, MP3_TRACK_ATTR_NAME, "CDATA", Byte.toString(buf[126]));
        }
        if (buf[127] > 0) {
            this.attributes.addAttribute("", MP3_GENRE_ATTR_NAME, MP3_GENRE_ATTR_NAME, "CDATA", Byte.toString(buf[127]));
        }
    }

    private String getID3TagValue(byte[] buf, int offset, int length) {
        String s = new String(buf, offset, length);
        int index = s.indexOf(0);
        if (index != -1) {
            s = s.substring(0, index);
        }
        return s.trim();
    }

    private void setID3HeaderAttributes(RandomAccessFile in) throws IOException {
        byte[] buffer = new byte[4];
        if (in.read(buffer, 0, 3) != 3) {
            return;
        }
        int header = buffer[0] << 16 & 0xFF0000 | buffer[1] << 8 & 0xFF00 | buffer[2] << 0 & 0xFF;
        do {
            header <<= 8;
            if (in.read(buffer, 3, 1) == 1) continue;
            return;
        } while (!MP3DirectoryGenerator.isSyncMark(header |= buffer[3] & 0xFF));
        int version = header >>> 19 & 3;
        int layer = 4 - (header >>> 17) & 3;
        int bitrate = header >>> 12 & 0xF;
        int frequency = header >>> 10 & 3;
        if (frequency == 3) {
            return;
        }
        int mode = header >>> 6 & 3;
        this.attributes.addAttribute("", MP3_FREQUENCY_ATTR_NAME, MP3_FREQUENCY_ATTR_NAME, "CDATA", MP3DirectoryGenerator.frequencyString(version, frequency));
        this.attributes.addAttribute("", MP3_MODE_ATTR_NAME, MP3_MODE_ATTR_NAME, "CDATA", MP3DirectoryGenerator.mode(mode));
        int frames = this.getVBRHeaderFrames(in, version, mode);
        if (frames != -1) {
            float medFrameSize = (float)in.length() / (float)frames;
            bitrate = (int)((double)(medFrameSize * (float)MP3DirectoryGenerator.frequency(version, frequency)) / 144000.0);
            this.attributes.addAttribute("", MP3_BITRATE_ATTR_NAME, MP3_BITRATE_ATTR_NAME, "CDATA", Integer.toString(bitrate));
        } else {
            this.attributes.addAttribute("", MP3_BITRATE_ATTR_NAME, MP3_BITRATE_ATTR_NAME, "CDATA", MP3DirectoryGenerator.bitrate(version, layer, bitrate));
        }
    }

    private static boolean isSyncMark(int header) {
        boolean sync;
        boolean bl = sync = (header & 0xFFF00000) == -1048576;
        if (sync) {
            boolean bl2 = sync = (header >>> 10 & 3) != 3;
        }
        if (sync) {
            boolean bl3 = sync = (header >>> 17 & 3) != 0;
        }
        if (sync) {
            sync = (header >>> 19 & 3) != 1;
        }
        return sync;
    }

    private int getVBRHeaderFrames(RandomAccessFile in, int version, int mode) throws IOException {
        byte[] buffer = new byte[12];
        int skip = version == 3 ? (mode == 3 ? 17 : 32) : (mode == 3 ? 9 : 17);
        while (skip > 0) {
            if (in.read() == -1) {
                return -1;
            }
            --skip;
        }
        if (in.read(buffer, 0, 12) != 12) {
            return -1;
        }
        if (buffer[0] != 88 || buffer[1] != 105 || buffer[2] != 110 || buffer[3] != 103) {
            return -1;
        }
        this.attributes.addAttribute("", MP3_VBR_ATTR_NAME, MP3_VBR_ATTR_NAME, "CDATA", "yes");
        int flags = (buffer[4] & 0xFF) << 24 | (buffer[5] & 0xFF) << 16 | (buffer[6] & 0xFF) << 8 | buffer[7] & 0xFF;
        if ((flags & 1) == 1) {
            int frames = (buffer[8] & 0xFF) << 24 | (buffer[9] & 0xFF) << 16 | (buffer[10] & 0xFF) << 8 | buffer[11] & 0xFF;
            return frames;
        }
        return -1;
    }

    private static String bitrate(int version, int layer, int bitrate_index) {
        return bitrates[version & 1][layer - 1][bitrate_index];
    }

    private static String mode(int mode) {
        switch (mode) {
            case 0: {
                return "Stereo";
            }
            case 1: {
                return "Joint stereo";
            }
            case 2: {
                return "Dual channel";
            }
            case 3: {
                return "Single channel";
            }
        }
        return null;
    }

    private static int frequency(int version, int frequency) {
        return frequencies[version][frequency];
    }

    private static String frequencyString(int version, int frequency) {
        return String.valueOf((float)MP3DirectoryGenerator.frequency(version, frequency) / 1000.0f);
    }
}

