/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.FileGeneratorBean;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class CSVGeneratorBean
extends FileGeneratorBean {
    public static final String NAMESPACE_URI = "http://apache.org/cocoon/csv/1.0";
    public static final String NAMESPACE_PREFIX = "csv";
    private static final String DEFAULT_ENCODING = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String DEFAULT_ESCAPE = "\"";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int UNLIMITED_MAXRECORDS = -1;
    private static final char[] INDENT_STRING = "\n          ".toCharArray();
    private String encoding = DEFAULT_ENCODING;
    private char separator = ",".charAt(0);
    private char escape = "\"".charAt(0);
    private int buffersize = 4096;
    private int fieldnumber = 1;
    private int recordnumber = 1;
    private int maxrecords;
    private boolean openrecord = false;
    private CharArrayWriter buffer = null;
    private Map columns = null;

    @Override
    public void dispose() {
        super.dispose();
        this.encoding = DEFAULT_ENCODING;
        this.separator = DEFAULT_SEPARATOR.charAt(0);
        this.escape = DEFAULT_ESCAPE.charAt(0);
        this.buffersize = 4096;
        this.buffer = null;
        this.columns = null;
        this.recordnumber = 1;
        this.fieldnumber = 1;
        this.openrecord = false;
    }

    @Override
    public void setup(SourceResolver resolver, Map object_model, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, object_model, source, parameters);
        boolean header = parameters.getParameterAsBoolean("process-headers", false);
        this.encoding = parameters.getParameter("encoding", DEFAULT_ENCODING);
        this.separator = parameters.getParameter("separator", DEFAULT_SEPARATOR).charAt(0);
        this.escape = parameters.getParameter("escape", DEFAULT_ESCAPE).charAt(0);
        this.buffersize = parameters.getParameterAsInteger("buffer-size", 4096);
        this.maxrecords = parameters.getParameterAsInteger("max-records", -1);
        this.buffer = new CharArrayWriter();
        this.columns = header ? new HashMap() : null;
        this.recordnumber = header ? 0 : 1;
        this.fieldnumber = 1;
        this.openrecord = false;
    }

    @Override
    public Serializable getKey() {
        StringBuffer key = new StringBuffer(this.inputSource.getURI());
        if (this.columns != null) {
            key.append("headers");
        }
        key.append(this.separator);
        key.append(this.maxrecords);
        key.append(this.escape);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        CSVReader csv = new CSVReader(this.inputSource, this.encoding, this.buffersize);
        try {
            int n;
            this.consumer.setDocumentLocator((Locator)csv);
            this.consumer.startDocument();
            this.consumer.startPrefixMapping(NAMESPACE_PREFIX, NAMESPACE_URI);
            this.indent(0);
            this.startElement("document");
            boolean unescaped = true;
            int n2 = -1;
            int n3 = -1;
            while ((n = csv.read()) >= 0 && (this.maxrecords == -1 || this.recordnumber <= this.maxrecords)) {
                int n4;
                if (n == this.escape) {
                    if (unescaped && n4 == this.escape) {
                        this.buffer.write(this.escape);
                    }
                    unescaped = !unescaped;
                    n4 = n;
                    continue;
                }
                if (unescaped && n == this.separator) {
                    this.dumpField();
                    n4 = n;
                    continue;
                }
                if (unescaped && (n == 13 || n == 10)) {
                    this.dumpField();
                    this.dumpRecord();
                    if (n == 10 && n4 != 13 || n == 13) {
                        ++this.recordnumber;
                    }
                    n4 = n;
                    continue;
                }
                this.buffer.write(n);
                n4 = n;
            }
            this.dumpField();
            this.dumpRecord();
            this.indent(0);
            this.endElement("document");
            this.consumer.endPrefixMapping(NAMESPACE_PREFIX);
            this.consumer.endDocument();
        }
        finally {
            csv.close();
        }
    }

    private void dumpField() throws SAXException {
        String header;
        if (this.buffer.size() < 1) {
            ++this.fieldnumber;
            return;
        }
        if (!this.openrecord) {
            this.indent(4);
            if (this.recordnumber > 0) {
                AttributesImpl attributes = new AttributesImpl();
                String value = Integer.toString(this.recordnumber);
                attributes.addCDATAAttribute("number", value);
                this.startElement("record", (Attributes)attributes);
            } else {
                this.startElement("header");
            }
            this.openrecord = true;
        }
        String element = "field";
        char[] array = this.buffer.toCharArray();
        this.indent(8);
        AttributesImpl attributes = new AttributesImpl();
        String value = Integer.toString(this.fieldnumber);
        attributes.addCDATAAttribute("number", value);
        if (this.recordnumber < 1) {
            this.columns.put(new Integer(this.fieldnumber), new String(array));
            element = "column";
        } else if (this.columns != null && (header = (String)this.columns.get(new Integer(this.fieldnumber))) != null) {
            attributes.addCDATAAttribute("column", header);
        }
        this.startElement(element, (Attributes)attributes);
        this.consumer.characters(array, 0, array.length);
        this.endElement(element);
        this.buffer.reset();
        ++this.fieldnumber;
    }

    private void dumpRecord() throws SAXException {
        if (this.openrecord) {
            this.indent(4);
            if (this.recordnumber > 0) {
                this.endElement("record");
            } else {
                this.endElement("header");
            }
            this.openrecord = false;
        }
        this.fieldnumber = 1;
    }

    private void indent(int level) throws SAXException {
        this.consumer.characters(INDENT_STRING, 0, level + 1);
    }

    private void startElement(String name) throws SAXException {
        this.startElement(name, XMLUtils.EMPTY_ATTRIBUTES);
    }

    private void startElement(String name, Attributes atts) throws SAXException {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        String qual = "csv:" + name;
        this.consumer.startElement(NAMESPACE_URI, name, qual, atts == null ? XMLUtils.EMPTY_ATTRIBUTES : atts);
    }

    private void endElement(String name) throws SAXException {
        String qual = "csv:" + name;
        this.consumer.endElement(NAMESPACE_URI, name, qual);
    }

    private static final class CSVReader
    extends Reader
    implements Locator {
        private String uri = null;
        private Reader input = null;
        private int column = 1;
        private int line = 1;
        private int last = -1;

        protected CSVReader(Source source, String encoding, int buffer) throws IOException {
            InputStream stream = source.getInputStream();
            InputStreamReader reader = new InputStreamReader(stream, encoding);
            this.input = new BufferedReader(reader, buffer);
            this.uri = source.getURI();
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this.uri;
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        public int getColumnNumber() {
            return this.column;
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }

        @Override
        public int read() throws IOException {
            int c = this.input.read();
            if (c < 0) {
                return c;
            }
            if (c == 10 && this.last != 13 || c == 13) {
                this.column = 1;
                ++this.line;
            }
            this.last = c;
            return c;
        }

        @Override
        public int read(char[] b, int o, int l) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (o < 0 || o > b.length || l < 0 || o + l > b.length || o + l < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (l == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[o] = (char)c;
            int i = 1;
            try {
                for (i = 1; i < l && (c = this.read()) != -1; ++i) {
                    b[o + i] = (char)c;
                }
            }
            catch (IOException ee) {
                return i;
            }
            return i;
        }
    }
}

