/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xslt;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.components.xslt.TraxErrorListener;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class TraxProcessor
extends AbstractLogEnabled
implements XSLTProcessor,
Serviceable,
Initializable,
Disposable,
Parameterizable,
Recyclable,
URIResolver {
    protected Store m_store;
    protected String m_transformerFactory;
    protected SAXTransformerFactory m_factory;
    protected SAXTransformerFactory m_defaultFactory;
    protected boolean m_useStore;
    protected boolean m_incrementalProcessing;
    protected SourceResolver m_resolver;
    protected boolean m_checkIncludes;
    protected Map m_includesMap = new HashMap();
    protected SAXParser saxParser;
    protected ServiceManager m_manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        this.saxParser = (SAXParser)this.m_manager.lookup(SAXParser.ROLE);
        this.m_resolver = (SourceResolver)this.m_manager.lookup(SourceResolver.ROLE);
        if (this.m_manager.hasService(Store.TRANSIENT_STORE)) {
            this.m_store = (Store)this.m_manager.lookup(Store.TRANSIENT_STORE);
        }
    }

    public void initialize() throws Exception {
        this.m_defaultFactory = this.m_factory = this.getTransformerFactory(this.m_transformerFactory);
    }

    public void dispose() {
        if (null != this.m_manager) {
            this.m_manager.release((Object)this.m_store);
            this.m_manager.release((Object)this.m_resolver);
            this.m_manager = null;
        }
        this.saxParser = null;
        this.m_store = null;
        this.m_resolver = null;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.m_useStore = params.getParameterAsBoolean("use-store", this.m_useStore);
        this.m_incrementalProcessing = params.getParameterAsBoolean("incremental-processing", this.m_incrementalProcessing);
        this.m_transformerFactory = params.getParameter("transformer-factory", null);
        this.m_checkIncludes = params.getParameterAsBoolean("check-includes", true);
        if (!this.m_useStore) {
            this.m_manager.release((Object)this.m_store);
            this.m_store = null;
        } else if (null == this.m_store) {
            String message = "XSLTProcessor: use-store is set to true, but unable to aquire the Store.";
            throw new ParameterException("XSLTProcessor: use-store is set to true, but unable to aquire the Store.");
        }
    }

    public void setTransformerFactory(String classname) {
        this.m_factory = this.getTransformerFactory(classname);
    }

    public TransformerHandler getTransformerHandler(Source stylesheet) throws XSLTProcessorException {
        return this.getTransformerHandler(stylesheet, null);
    }

    public TransformerHandler getTransformerHandler(Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        XSLTProcessor.TransformerHandlerAndValidity validity = this.getTransformerHandlerAndValidity(stylesheet, filter);
        return validity.getTransfomerHandler();
    }

    public XSLTProcessor.TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet) throws XSLTProcessorException {
        return this.getTransformerHandlerAndValidity(stylesheet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSLTProcessor.TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        XSLTProcessor.TransformerHandlerAndValidity handlerAndValidity;
        String id = stylesheet.getURI();
        try {
            handlerAndValidity = this.getTemplates(stylesheet, id);
            if (handlerAndValidity != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Reusing Templates for " + id));
                }
                return handlerAndValidity;
            }
        }
        catch (Exception e) {
            throw new XSLTProcessorException("Error retrieving template", (Throwable)e);
        }
        TraxErrorListener errorListener = new TraxErrorListener(stylesheet.getURI());
        try {
            SourceValidity validity;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Creating new Templates for " + id));
            }
            this.m_factory.setErrorListener(errorListener);
            TemplatesHandler templatesHandler = this.m_factory.newTemplatesHandler();
            templatesHandler.setSystemId(id);
            if (filter != null) {
                filter.setContentHandler(templatesHandler);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Source = " + stylesheet + ", templatesHandler = " + templatesHandler));
            }
            if ((validity = stylesheet.getValidity()) != null && this.m_checkIncludes) {
                this.m_includesMap.put(id, new ArrayList());
            }
            try {
                List includes;
                this.sourceToSAX(stylesheet, filter != null ? (ContentHandler)((Object)filter) : templatesHandler);
                Templates template = templatesHandler.getTemplates();
                if (null == template) {
                    throw new XSLTProcessorException("Unable to create templates for stylesheet: " + stylesheet.getURI());
                }
                Class<?> clazz = template.getClass();
                if (clazz.getName().equals("org.apache.xalan.templates.StylesheetRoot")) {
                    Method method = clazz.getMethod("setHref", String.class);
                    method.invoke((Object)template, id);
                }
                this.putTemplates(template, stylesheet, id);
                TransformerHandler handler = this.m_factory.newTransformerHandler(template);
                handler.getTransformer().setErrorListener(new TraxErrorListener(stylesheet.getURI()));
                handler.getTransformer().setURIResolver(this);
                if (validity != null && this.m_checkIncludes && (includes = (List)this.m_includesMap.get(id)) != null) {
                    AggregatedValidity aggregated = new AggregatedValidity();
                    aggregated.add(validity);
                    for (int i = includes.size() - 1; i >= 0; --i) {
                        aggregated.add((SourceValidity)((Object[])includes.get(i))[1]);
                    }
                    validity = aggregated;
                }
                handlerAndValidity = new MyTransformerHandlerAndValidity(handler, validity);
            }
            finally {
                if (this.m_checkIncludes) {
                    this.m_includesMap.remove(id);
                }
            }
            return handlerAndValidity;
        }
        catch (Exception e) {
            Throwable realEx = errorListener.getThrowable();
            if (realEx == null) {
                realEx = e;
            }
            if (realEx instanceof RuntimeException) {
                throw (RuntimeException)realEx;
            }
            if (realEx instanceof XSLTProcessorException) {
                throw (XSLTProcessorException)realEx;
            }
            throw new XSLTProcessorException("Exception when creating Transformer from " + stylesheet.getURI(), realEx);
        }
    }

    private void sourceToSAX(Source source, ContentHandler handler) throws SAXException, IOException, ProcessingException {
        if (source instanceof XMLizable) {
            ((XMLizable)source).toSAX(handler);
        } else {
            this.saxParser.parse(SourceUtil.getInputSource((Source)source), handler);
        }
    }

    public void transform(Source source, Source stylesheet, Parameters params, Result result) throws XSLTProcessorException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Transform source = " + source + ", stylesheet = " + stylesheet + ", parameters = " + params + ", result = " + result));
            }
            TransformerHandler handler = this.getTransformerHandler(stylesheet);
            if (params != null) {
                Transformer transformer = handler.getTransformer();
                transformer.clearParameters();
                String[] names = params.getNames();
                for (int i = names.length - 1; i >= 0; --i) {
                    transformer.setParameter(names[i], params.getParameter(names[i]));
                }
            }
            handler.setResult(result);
            this.sourceToSAX(source, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Transform done");
            }
        }
        catch (SAXException e) {
            String message = "Error in running Transformation";
            throw new XSLTProcessorException("Error in running Transformation", (Throwable)e);
        }
        catch (Exception e) {
            String message = "Error in running Transformation";
            throw new XSLTProcessorException("Error in running Transformation", (Throwable)e);
        }
    }

    private SAXTransformerFactory getTransformerFactory(String factoryName) {
        SAXTransformerFactory _factory;
        if (null == factoryName) {
            _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        } else {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                _factory = (SAXTransformerFactory)loader.loadClass(factoryName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this.getLogger().error((Object)("Cannot find the requested TrAX factory '" + factoryName + "'. Using default TrAX Transformer Factory instead."));
                if (this.m_factory != null) {
                    return this.m_factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (ClassCastException cce) {
                this.getLogger().error((Object)("The indicated class '" + factoryName + "' is not a TrAX Transformer Factory. Using default TrAX Transformer Factory instead."));
                if (this.m_factory != null) {
                    return this.m_factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (Exception e) {
                this.getLogger().error((Object)("Error found loading the requested TrAX Transformer Factory '" + factoryName + "'. Using default TrAX Transformer Factory instead."));
                if (this.m_factory != null) {
                    return this.m_factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
        }
        _factory.setErrorListener(new TraxErrorListener(null));
        _factory.setURIResolver(this);
        if (_factory.getClass().getName().equals("org.apache.xalan.processor.TransformerFactoryImpl")) {
            _factory.setAttribute("http://xml.apache.org/xalan/features/incremental", this.m_incrementalProcessing);
        }
        if (_factory.getClass().getName().equals("net.sf.saxon.TransformerFactoryImpl")) {
            _factory.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        }
        return _factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSLTProcessor.TransformerHandlerAndValidity getTemplates(Source stylesheet, String id) throws IOException, TransformerException {
        SourceValidity storedValidity;
        Object[] templateAndValidityAndIncludes;
        block10: {
            List includes;
            SourceValidity newValidity;
            if (!this.m_useStore) {
                return null;
            }
            String key = "XSLTTemplate: " + id + '(' + this.m_factory.getClass().getName() + ')';
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("getTemplates: stylesheet " + id));
            }
            if ((templateAndValidityAndIncludes = (Object[])this.m_store.get((Object)key)) == null) {
                return null;
            }
            storedValidity = (SourceValidity)templateAndValidityAndIncludes[1];
            int valid = storedValidity.isValid();
            if (valid == 0 && (newValidity = stylesheet.getValidity()) != null) {
                valid = storedValidity.isValid(newValidity);
            }
            if (valid != 1) {
                this.m_store.remove((Object)key);
                return null;
            }
            if (!this.m_checkIncludes || (includes = (List)templateAndValidityAndIncludes[2]) == null) break block10;
            AggregatedValidity aggregated = new AggregatedValidity();
            aggregated.add(storedValidity);
            for (int i = includes.size() - 1; i >= 0; --i) {
                Object[] pair = (Object[])includes.get(i);
                storedValidity = (SourceValidity)pair[1];
                aggregated.add(storedValidity);
                valid = storedValidity.isValid();
                if (valid == 0) {
                    Source includedSource;
                    block9: {
                        includedSource = null;
                        try {
                            includedSource = this.m_resolver.resolveURI((String)pair[0]);
                            SourceValidity included = includedSource.getValidity();
                            if (included == null) break block9;
                            valid = storedValidity.isValid(included);
                        }
                        catch (Throwable throwable) {
                            this.m_resolver.release(includedSource);
                            throw throwable;
                        }
                    }
                    this.m_resolver.release(includedSource);
                }
                if (valid == 1) continue;
                this.m_store.remove((Object)key);
                return null;
            }
            storedValidity = aggregated;
        }
        TransformerHandler handler = this.m_factory.newTransformerHandler((Templates)templateAndValidityAndIncludes[0]);
        handler.getTransformer().setErrorListener(new TraxErrorListener(stylesheet.getURI()));
        handler.getTransformer().setURIResolver(this);
        return new MyTransformerHandlerAndValidity(handler, storedValidity);
    }

    private void putTemplates(Templates templates, Source stylesheet, String id) throws IOException {
        if (!this.m_useStore) {
            return;
        }
        String key = "XSLTTemplate: " + id + '(' + this.m_factory.getClass().getName() + ')';
        SourceValidity validity = stylesheet.getValidity();
        if (null != validity) {
            Object[] templateAndValidityAndIncludes = new Object[3];
            templateAndValidityAndIncludes[0] = templates;
            templateAndValidityAndIncludes[1] = validity;
            if (this.m_checkIncludes) {
                templateAndValidityAndIncludes[2] = this.m_includesMap.get(id);
            }
            this.m_store.store((Object)key, (Object)templateAndValidityAndIncludes);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public javax.xml.transform.Source resolve(String href, String base) throws TransformerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputSource getInputSource(Source source) throws IOException {
        InputSource newObject = new InputSource(source.getInputStream());
        newObject.setSystemId(source.getURI());
        return newObject;
    }

    public void recycle() {
        this.m_includesMap.clear();
        if (this.m_factory != this.m_defaultFactory) {
            this.m_factory = this.m_defaultFactory;
        }
    }

    public static class MyTransformerHandlerAndValidity
    extends XSLTProcessor.TransformerHandlerAndValidity {
        protected MyTransformerHandlerAndValidity(TransformerHandler handler, SourceValidity validity) {
            super(handler, validity);
        }
    }
}

