/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xpointer;

import java.util.HashMap;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XPointerContext
extends AbstractLogEnabled
implements PrefixResolver {
    private Source source;
    private Document document;
    private XMLConsumer xmlConsumer;
    private String xpointer;
    private HashMap prefixes = new HashMap();
    private ServiceManager manager;

    public XPointerContext(String xpointer, Source source, XMLConsumer xmlConsumer, ServiceManager manager) {
        this.source = source;
        this.xmlConsumer = xmlConsumer;
        this.manager = manager;
        this.xpointer = xpointer;
        this.prefixes.put("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public Document getDocument() throws SAXException, ResourceNotFoundException {
        if (this.document == null) {
            try {
                this.document = SourceUtil.toDOM((ServiceManager)this.manager, (Source)this.source);
            }
            catch (ResourceNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException("Error during XPointer evaluation while trying to load " + this.source.getURI(), e);
            }
        }
        return this.document;
    }

    public Source getSource() {
        return this.source;
    }

    public XMLConsumer getXmlConsumer() {
        return this.xmlConsumer;
    }

    public String getXPointer() {
        return this.xpointer;
    }

    public ServiceManager getServiceManager() {
        return this.manager;
    }

    public void addPrefix(String prefix, String namespace) throws SAXException {
        if (prefix.equalsIgnoreCase("xml")) {
            return;
        }
        if (prefix.equals("xmlns")) {
            return;
        }
        if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
            return;
        }
        if (namespace.equals("http://www.w3.org/2000/xmlns/")) {
            return;
        }
        this.prefixes.put(prefix, namespace);
    }

    public String prefixToNamespace(String prefix) {
        return (String)this.prefixes.get(prefix);
    }
}

