/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.impl.ZipSource;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;

public class ZipSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
ThreadSafe,
Serviceable {
    private ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public Source getSource(String location, Map parameters) throws IOException {
        Source archive;
        int protocolEnd = location.indexOf(":");
        if (protocolEnd == -1) {
            throw new MalformedURLException("Protocol ':' separator is missing in URL: " + location);
        }
        int archiveEnd = location.lastIndexOf("!/");
        if (archiveEnd == -1) {
            throw new MalformedURLException("File path '!/' separator is missing in URL: " + location);
        }
        String protocol = location.substring(0, protocolEnd);
        String archiveURL = location.substring(protocolEnd + 1, archiveEnd);
        String filePath = location.substring(archiveEnd + 2);
        SourceResolver resolver = null;
        try {
            resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
            archive = resolver.resolveURI(archiveURL);
        }
        catch (ServiceException se) {
            throw new SourceException("SourceResolver is not available.", (Throwable)se);
        }
        finally {
            this.manager.release((Object)resolver);
        }
        return new ZipSource(protocol, archive, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Source source) {
        SourceResolver resolver = null;
        try {
            resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
            ((ZipSource)source).dispose(resolver);
        }
        catch (ServiceException e) {
            this.getLogger().error((Object)"ServiceException while looking up SourceResolver in release()", (Throwable)e);
        }
        finally {
            this.manager.release((Object)resolver);
        }
    }
}

