/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.cocoon.components.source.impl.ContextSourceFactory;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.TraversableSource;

public class TraversableContextSource
implements Source,
TraversableSource {
    protected final Source wrappedSource;
    protected final Set children;
    protected final ContextSourceFactory factory;
    protected final String path;
    protected final String scheme;

    public TraversableContextSource(Source source, Set children, ContextSourceFactory factory, String path, String scheme) {
        this.wrappedSource = source;
        this.children = children;
        this.factory = factory;
        this.path = path;
        this.scheme = scheme;
    }

    public boolean exists() {
        return this.wrappedSource.exists();
    }

    public long getContentLength() {
        return this.wrappedSource.getContentLength();
    }

    public InputStream getInputStream() throws IOException, SourceNotFoundException {
        return this.wrappedSource.getInputStream();
    }

    public long getLastModified() {
        return this.wrappedSource.getLastModified();
    }

    public String getMimeType() {
        return this.wrappedSource.getMimeType();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getURI() {
        return this.wrappedSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.wrappedSource.getValidity();
    }

    public void refresh() {
        this.wrappedSource.refresh();
    }

    public Source getChild(String name) throws SourceException {
        String postfixOne = '/' + name + '/';
        String postfixTwo = '/' + name;
        for (String uri : this.children) {
            if (uri.endsWith(postfixOne)) {
                uri = "context:/" + uri;
                uri = uri.substring(0, uri.length() - 1);
                try {
                    return this.factory.getSource(uri, null);
                }
                catch (IOException ioe) {
                    throw new SourceException("Unable to get source for: " + uri);
                }
            }
            if (!uri.endsWith(postfixTwo)) continue;
            uri = "context:/" + uri;
            try {
                return this.factory.getSource(uri, null);
            }
            catch (IOException ioe) {
                throw new SourceException("Unable to get source for: " + uri);
            }
        }
        return null;
    }

    public Collection getChildren() throws SourceException {
        ArrayList<Source> l = new ArrayList<Source>();
        for (String uri : this.children) {
            uri = "context:/" + uri;
            try {
                l.add(this.factory.getSource(uri, null));
            }
            catch (IOException ioe) {
                Iterator ci = l.iterator();
                while (ci.hasNext()) {
                    this.factory.release((Source)ci.next());
                }
                throw new SourceException("Unable to get source for: " + uri);
            }
        }
        return l;
    }

    public String getName() {
        String uri = this.wrappedSource.getURI();
        return uri.substring(uri.lastIndexOf(47) + 1);
    }

    public Source getParent() throws SourceException {
        String uri = "context:/" + this.path;
        uri = uri.substring(0, uri.lastIndexOf(47));
        try {
            return this.factory.getSource(uri, null);
        }
        catch (IOException ioe) {
            throw new SourceException("Unable to get source for: " + uri);
        }
    }

    public boolean isCollection() {
        return true;
    }
}

