/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.location;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cocoon.util.location.Locatable;
import org.apache.cocoon.util.location.LocatableException;
import org.apache.cocoon.util.location.LocatedRuntimeException;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.apache.cocoon.util.location.LocationUtils;
import org.apache.cocoon.util.location.MultiLocatable;
import org.apache.commons.lang.exception.ExceptionUtils;

public class LocatedException
extends Exception
implements LocatableException,
MultiLocatable {
    private List locations;

    public LocatedException(String message) {
        this(message, null, null);
    }

    public LocatedException(String message, Throwable cause) {
        this(message, cause, null);
    }

    public LocatedException(String message, Location location) {
        this(message, null, location);
    }

    public LocatedException(String message, Throwable cause, Location location) {
        super(message, cause);
        LocatedException.ensureCauseChainIsSet(cause);
        LocatedException.addCauseLocations(this, cause);
        this.addLocation(location);
    }

    public static void ensureCauseChainIsSet(Throwable thr) {
        while (thr != null && !(thr instanceof LocatedRuntimeException) && !(thr instanceof LocatedException)) {
            Throwable parent = ExceptionUtils.getCause((Throwable)thr);
            if (thr.getCause() == null && parent != null) {
                thr.initCause(parent);
            }
            thr = parent;
        }
    }

    public static void addCauseLocations(MultiLocatable self, Throwable cause) {
        if (cause == null || cause instanceof Locatable) {
            return;
        }
        LocatedException.addCauseLocations(self, ExceptionUtils.getCause((Throwable)cause));
        Location loc = LocationUtils.getLocation(cause);
        if (LocationUtils.isKnown(loc)) {
            String name = cause.getClass().getName();
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                name = name.substring(pos + 1);
            }
            loc = new LocationImpl("[" + name + "]", loc.getURI(), loc.getLineNumber(), loc.getColumnNumber());
            self.addLocation(loc);
        }
    }

    @Override
    public Location getLocation() {
        return this.locations == null ? null : (Location)this.locations.get(0);
    }

    @Override
    public List getLocations() {
        return this.locations == null ? Collections.EMPTY_LIST : this.locations;
    }

    @Override
    public String getRawMessage() {
        return super.getMessage();
    }

    public static String getMessage(String message, List locations) {
        if (locations == null || locations.isEmpty()) {
            return message;
        }
        StringBuffer buf = message == null ? new StringBuffer() : new StringBuffer(message);
        for (int i = 0; i < locations.size(); ++i) {
            buf.append("\n\tat ").append(LocationUtils.toString((Location)locations.get(i)));
        }
        return buf.toString();
    }

    @Override
    public String getMessage() {
        return LocatedException.getMessage(super.getMessage(), this.locations);
    }

    @Override
    public void addLocation(Location loc) {
        if (LocationUtils.isUnknown(loc)) {
            return;
        }
        if (this.locations == null) {
            this.locations = new ArrayList(1);
        }
        this.locations.add(LocationImpl.get(loc));
    }
}

