/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.cocoon.ConstantsInitializationException;

public final class Constants {
    private static final String PROPS_FILE = "org/apache/cocoon/cocoon.properties";
    static final Properties properties = new Properties();
    public static final String NAME = "Cocoon";
    public static final String VERSION;
    public static final String COMPLETE_NAME;
    public static final String CONF_VERSION = "2.2";
    public static final String YEAR;
    public static final String SHOWTIME_PARAM = "cocoon-showtime";
    public static final String VIEW_PARAM = "cocoon-view";
    public static final String ACTION_PARAM = "cocoon-action";
    public static final String ACTION_PARAM_PREFIX = "cocoon-action-";
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String LINK_CONTENT_TYPE = "application/x-cocoon-links";
    public static final String LINK_VIEW = "links";
    public static final String LINK_OBJECT = "link";
    public static final String LINK_COLLECTION_OBJECT = "link-collection";
    public static final String NOTIFYING_OBJECT = "notifying-object";
    public static final String INDEX_URI = "index";
    public static final String DEFAULT_CONTEXT_DIR = "./webapp";
    public static final String DEFAULT_DEST_DIR = "./site";
    public static final String DEFAULT_WORK_DIR = "./work";
    public static final String DEFAULT_CONF_FILE = "cocoon.xconf";
    public static final String ERROR_NAMESPACE_URI = "http://apache.org/cocoon/error/2.1";
    public static final String ERROR_NAMESPACE_PREFIX = "error";
    public static final String CONTEXT_ENVIRONMENT_CONTEXT = "environment-context";
    public static final String CONTEXT_WORK_DIR = "work-directory";
    public static final String CONTEXT_CACHE_DIR = "cache-directory";
    public static final String CONTEXT_ENV_PREFIX = "env-prefix";
    public static final String CONTEXT_VPC_PREFIX = "vpc-";
    public static final String WIRING = "wiring.xml";
    public static final String BLOCK_META_DIR = "COB-INF";
    public static final String CONTEXT_DEFAULT_ENCODING = "default-encoding";

    static {
        try {
            InputStream is = Constants.class.getClassLoader().getResourceAsStream(PROPS_FILE);
            if (null == is) {
                throw new ConstantsInitializationException("Cocoon cannot find required properties from org/apache/cocoon/cocoon.properties");
            }
            properties.load(is);
        }
        catch (IOException ioe) {
            throw new ConstantsInitializationException("Cocoon cannot load required properties from org/apache/cocoon/cocoon.properties", ioe);
        }
        VERSION = properties.getProperty("version");
        COMPLETE_NAME = "Apache Cocoon " + VERSION;
        YEAR = properties.getProperty("year");
    }
}

