/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript.fom;

import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.components.flow.javascript.fom.PageLocal;
import org.apache.cocoon.components.flow.javascript.fom.PageLocalScope;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class PageLocalScopeImpl
implements PageLocalScope {
    private Map locals;
    private Scriptable scope;

    public PageLocalScopeImpl(Scriptable scope) {
        this.locals = new HashMap();
        this.scope = scope;
    }

    private Scriptable newObject() {
        try {
            return Context.getCurrentContext().newObject(this.scope);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            throw new Error("error: " + ignored);
        }
    }

    private PageLocalScopeImpl(PageLocalScopeImpl toBeCloned) {
        this.scope = toBeCloned.scope;
        this.locals = new HashMap();
        for (Map.Entry e : toBeCloned.locals.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            Scriptable obj = (Scriptable)value;
            Scriptable newObj = this.newObject();
            Object[] ids = obj.getIds();
            for (int i = 0; i < ids.length; ++i) {
                String name = ids[i].toString();
                newObj.put(name, newObj, obj.get(name, obj));
            }
            value = newObj;
            this.locals.put(key, value);
        }
    }

    private Scriptable resolve(PageLocal local) {
        Object id = local.getId();
        Scriptable result = (Scriptable)this.locals.get(id);
        if (result == null) {
            result = this.newObject();
            this.locals.put(id, result);
        }
        return result;
    }

    @Override
    public boolean has(PageLocal local, String name) {
        Scriptable obj = this.resolve(local);
        return obj.has(name, obj);
    }

    @Override
    public boolean has(PageLocal local, int index) {
        Scriptable obj = this.resolve(local);
        return obj.has(index, obj);
    }

    @Override
    public Object get(PageLocal local, String name) {
        Scriptable obj = this.resolve(local);
        return obj.get(name, obj);
    }

    @Override
    public Object get(PageLocal local, int index) {
        Scriptable obj = this.resolve(local);
        return obj.get(index, obj);
    }

    @Override
    public void put(PageLocal local, String name, Object value) {
        Scriptable obj = this.resolve(local);
        obj.put(name, obj, value);
    }

    @Override
    public void put(PageLocal local, int index, Object value) {
        Scriptable obj = this.resolve(local);
        obj.put(index, obj, value);
    }

    @Override
    public void delete(PageLocal local, String name) {
        Scriptable obj = this.resolve(local);
        obj.delete(name);
    }

    @Override
    public void delete(PageLocal local, int index) {
        Scriptable obj = this.resolve(local);
        obj.delete(index);
    }

    @Override
    public Object[] getIds(PageLocal local) {
        Scriptable obj = this.resolve(local);
        return obj.getIds();
    }

    @Override
    public Object getDefaultValue(PageLocal local, Class hint) {
        Scriptable obj = this.resolve(local);
        return obj.getDefaultValue(hint);
    }

    public PageLocalScopeImpl duplicate() {
        return new PageLocalScopeImpl(this);
    }

    @Override
    public PageLocal createPageLocal() {
        return null;
    }
}

