/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.url;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.URLRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class StreamJDKRegistryEntry
extends AbstractRegistryEntry
implements URLRegistryEntry {
    public static final float PRIORITY = 1000000.0f;
    static Component mediaComponent = new Label();
    static MediaTracker mediaTracker = new MediaTracker(mediaComponent);
    static int id = 0;

    public StreamJDKRegistryEntry() {
        super("Stream-JDK", 1000000.0f, new String[0], new String[]{"image/gif"});
    }

    public boolean isCompatibleURL(ParsedURL purl) {
        String contentType = purl.getContentType();
        if (contentType == null) {
            return false;
        }
        Iterator iter = this.getMimeTypes().iterator();
        while (iter.hasNext()) {
            if (!contentType.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter handleURL(ParsedURL purl, boolean needRawData) {
        InputStream is = null;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int len;
            is = purl.openStream();
            while ((len = is.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        catch (IOException ioe) {
            Filter filter = null;
            return filter;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
        buffer = bos.toByteArray();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image img = tk.createImage(buffer);
        if (img == null) {
            return null;
        }
        RenderedImage ri = this.loadImage(img);
        if (ri == null) {
            return null;
        }
        return new RedRable(GraphicsUtil.wrap((RenderedImage)ri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage loadImage(Image img) {
        int myID;
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        MediaTracker mediaTracker = StreamJDKRegistryEntry.mediaTracker;
        synchronized (mediaTracker) {
            myID = id++;
        }
        StreamJDKRegistryEntry.mediaTracker.addImage(img, myID);
        while (true) {
            try {
                StreamJDKRegistryEntry.mediaTracker.waitForID(myID);
            }
            catch (InterruptedException ie) {
                continue;
            }
            break;
        }
        StreamJDKRegistryEntry.mediaTracker.removeImage(img, myID);
        if (img.getWidth(null) == -1 || img.getHeight(null) == -1) {
            return null;
        }
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(img, 0, 0, null);
        g2d.dispose();
        return bi;
    }
}

