/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.web.fileserver;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.clerezza.utils.osgi.BundlePathNode;
import org.apache.clerezza.web.fileserver.FileServer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.ComponentContext;
import org.wymiwyg.commons.util.dirbrowser.FilePathNode;
import org.wymiwyg.commons.util.dirbrowser.MultiPathNode;
import org.wymiwyg.commons.util.dirbrowser.PathNode;

@Path(value="static")
public class BundleFileServer
implements BundleListener {
    private volatile FileServer fileServer;
    private Map<Bundle, PathNode> bundleNodeMap = Collections.synchronizedMap(new HashMap());
    private String extraPath;

    protected void activate(ComponentContext context) throws IOException, URISyntaxException {
        for (Bundle bundle : context.getBundleContext().getBundles()) {
            this.registerStaticFiles(bundle);
        }
        context.getBundleContext().addBundleListener((BundleListener)this);
        this.extraPath = context.getBundleContext().getProperty("org.apache.clerezza.web.fileserver.static.extra");
        this.updateFileServer();
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                this.registerStaticFiles(bundle);
                break;
            }
            case 4: {
                this.unregisterStaticFiles(bundle);
            }
        }
        this.updateFileServer();
    }

    private void registerStaticFiles(Bundle bundle) {
        BundlePathNode pathNode = new BundlePathNode(bundle, "META-INF/static-web");
        this.bundleNodeMap.put(bundle, (PathNode)pathNode);
    }

    private void unregisterStaticFiles(Bundle bundle) {
        this.bundleNodeMap.remove(bundle);
    }

    @GET
    @Path(value="{path:.+}")
    public PathNode getStaticFile(@PathParam(value="path") String path) {
        PathNode node = this.fileServer.getNode(path);
        return node;
    }

    private void updateFileServer() {
        HashSet<PathNode> nodes = new HashSet<PathNode>(this.bundleNodeMap.values());
        if (this.extraPath != null) {
            nodes.add((PathNode)new FilePathNode(this.extraPath));
        }
        MultiPathNode multiPathNode = new MultiPathNode(nodes.toArray(new PathNode[nodes.size()]));
        this.fileServer = new FileServer((PathNode)multiPathNode);
    }
}

