/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.wymiwyg.commons.util.dirbrowser.PathNameFilter;
import org.wymiwyg.commons.util.dirbrowser.PathNode;

public class BundlePathNode
implements PathNode {
    Bundle bundle;
    String path;

    public BundlePathNode(Bundle bundle, String path) {
        this.bundle = bundle;
        this.path = path.charAt(0) == '/' ? path.substring(1) : path;
    }

    public PathNode getSubPath(String requestPath) {
        StringWriter mergedPath = new StringWriter(255);
        mergedPath.append(this.path);
        if (!this.path.isEmpty() && this.path.charAt(this.path.length() - 1) != '/') {
            mergedPath.append('/');
        }
        if (requestPath.charAt(0) == '/') {
            mergedPath.append(requestPath.substring(1));
        } else {
            mergedPath.append(requestPath);
        }
        return new BundlePathNode(this.bundle, mergedPath.toString());
    }

    public boolean isDirectory() {
        String normalizedPath = this.path.charAt(this.path.length() - 1) != '/' ? this.path + "/" : this.path;
        return this.bundle.getEntryPaths(normalizedPath) != null;
    }

    public String[] list(PathNameFilter filter) {
        String[] unfilterd;
        ArrayList<String> resultList = new ArrayList<String>();
        for (String entry : unfilterd = this.list()) {
            if (!filter.accept((PathNode)this, entry)) continue;
            resultList.add(entry);
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public String[] list() {
        ArrayList<String> resultList = new ArrayList<String>();
        Enumeration absPathEnum = this.bundle.getEntryPaths(this.path);
        if (absPathEnum != null) {
            int pathLength = this.path.length();
            while (absPathEnum.hasMoreElements()) {
                String absPath = (String)absPathEnum.nextElement();
                resultList.add(absPath.substring(pathLength));
            }
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public InputStream getInputStream() throws IOException {
        return this.bundle.getEntry(this.path).openStream();
    }

    public long getLength() {
        return -1L;
    }

    public String getPath() {
        return this.path;
    }

    public Date getLastModified() {
        return null;
    }

    public boolean exists() {
        return this.bundle.getEntry(this.path) != null;
    }

    public String toString() {
        return "BundlePathNode for Path " + this.path + " in bundle " + this.bundle;
    }
}

