/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.simple.storage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleGraph;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleImmutableGraph;
import org.apache.clerezza.rdf.core.access.EntityAlreadyExistsException;
import org.apache.clerezza.rdf.core.access.EntityUndeletableException;
import org.apache.clerezza.rdf.core.access.NoSuchEntityException;
import org.apache.clerezza.rdf.core.access.WeightedTcProvider;
import org.osgi.service.component.annotations.Component;

@Component(service={WeightedTcProvider.class}, property={"general.purpose.tc=true"})
public class SimpleTcProvider
implements WeightedTcProvider {
    private Map<IRI, Graph> tripleMap = new HashMap<IRI, Graph>();

    public ImmutableGraph createImmutableGraph(IRI name, Graph triples) throws EntityAlreadyExistsException {
        if (name == null || name.getUnicodeString() == null || name.getUnicodeString().trim().length() == 0) {
            throw new IllegalArgumentException("Name must not be null");
        }
        try {
            this.getGraph(name);
        }
        catch (NoSuchEntityException e) {
            Object result = triples == null ? new SimpleImmutableGraph((Graph)new SimpleGraph()) : (ImmutableGraph.class.isAssignableFrom(triples.getClass()) ? (ImmutableGraph)triples : new SimpleImmutableGraph(triples));
            this.tripleMap.put(name, (Graph)result);
            return result;
        }
        throw new EntityAlreadyExistsException(name);
    }

    public Graph createGraph(IRI name) throws EntityAlreadyExistsException {
        if (name == null || name.getUnicodeString() == null || name.getUnicodeString().trim().length() == 0) {
            throw new IllegalArgumentException("Name must not be null");
        }
        try {
            this.getGraph(name);
        }
        catch (NoSuchEntityException e) {
            SimpleGraph result = new SimpleGraph();
            this.tripleMap.put(name, (Graph)result);
            return result;
        }
        throw new EntityAlreadyExistsException(name);
    }

    public void deleteGraph(IRI name) throws NoSuchEntityException, EntityUndeletableException {
        if (this.tripleMap.remove(name) == null) {
            throw new NoSuchEntityException(name);
        }
    }

    public ImmutableGraph getImmutableGraph(IRI name) throws NoSuchEntityException {
        Graph tripleCollection = this.tripleMap.get(name);
        if (tripleCollection == null) {
            throw new NoSuchEntityException(name);
        }
        if (ImmutableGraph.class.isAssignableFrom(tripleCollection.getClass())) {
            return (ImmutableGraph)tripleCollection;
        }
        throw new NoSuchEntityException(name);
    }

    public Graph getMGraph(IRI name) throws NoSuchEntityException {
        Graph tripleCollection = this.tripleMap.get(name);
        if (tripleCollection == null) {
            throw new NoSuchEntityException(name);
        }
        if (!ImmutableGraph.class.isAssignableFrom(tripleCollection.getClass())) {
            return tripleCollection;
        }
        throw new NoSuchEntityException(name);
    }

    public Set<IRI> getNames(ImmutableGraph graph) {
        throw new UnsupportedOperationException("Not supported yet. equals() has to be implemented first");
    }

    public Graph getGraph(IRI name) throws NoSuchEntityException {
        Graph tripleCollection = this.tripleMap.get(name);
        if (tripleCollection == null) {
            throw new NoSuchEntityException(name);
        }
        return tripleCollection;
    }

    public int getWeight() {
        return 1;
    }

    public Set<IRI> listImmutableGraphs() {
        HashSet<IRI> result = new HashSet<IRI>();
        for (IRI uriRef : this.listGraphs()) {
            if (!(this.tripleMap.get(uriRef) instanceof ImmutableGraph)) continue;
            result.add(uriRef);
        }
        return result;
    }

    public Set<IRI> listMGraphs() {
        HashSet<IRI> result = new HashSet<IRI>();
        for (IRI uriRef : this.listGraphs()) {
            if (this.tripleMap.get(uriRef) instanceof ImmutableGraph) continue;
            result.add(uriRef);
        }
        return result;
    }

    public Set<IRI> listGraphs() {
        return this.tripleMap.keySet();
    }
}

