/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils.simple;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.AbstractGraph;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleImmutableGraph;

public class SimpleGraph
extends AbstractGraph {
    final Set<Triple> triples;
    private boolean checkConcurrency = false;
    private final Set<SoftReference<SimpleIterator>> iterators = Collections.synchronizedSet(new HashSet());

    public SimpleGraph() {
        this.triples = Collections.synchronizedSet(new HashSet());
    }

    public SimpleGraph(Iterator<Triple> iterator) {
        this.triples = new HashSet<Triple>();
        while (iterator.hasNext()) {
            Triple triple = iterator.next();
            this.triples.add(triple);
        }
    }

    public SimpleGraph(Set<Triple> baseSet) {
        this.triples = baseSet;
    }

    public SimpleGraph(Collection<Triple> baseCollection) {
        this.triples = new HashSet<Triple>(baseCollection);
    }

    @Override
    public int performSize() {
        return this.triples.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Triple> performFilter(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        ArrayList<Triple> tripleList = new ArrayList<Triple>();
        Set<Triple> set = this.triples;
        synchronized (set) {
            for (Triple triple : this.triples) {
                if (subject != null && !triple.getSubject().equals(subject) || predicate != null && !triple.getPredicate().equals((Object)predicate) || object != null && !triple.getObject().equals(object)) continue;
                tripleList.add(triple);
            }
            Iterator<Triple> listIter = tripleList.iterator();
            SimpleIterator resultIter = new SimpleIterator(listIter);
            if (this.checkConcurrency) {
                this.iterators.add(new SoftReference<SimpleIterator>(resultIter));
            }
            return resultIter;
        }
    }

    @Override
    public boolean performAdd(Triple e) {
        boolean modified = this.triples.add(e);
        if (modified) {
            this.invalidateIterators(null);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateIterators(SimpleIterator caller) {
        if (!this.checkConcurrency) {
            return;
        }
        HashSet<SoftReference<SimpleIterator>> oldReferences = new HashSet<SoftReference<SimpleIterator>>();
        Set<SoftReference<SimpleIterator>> set = this.iterators;
        synchronized (set) {
            for (SoftReference<SimpleIterator> softReference : this.iterators) {
                SimpleIterator simpleIterator = softReference.get();
                if (simpleIterator == null) {
                    oldReferences.add(softReference);
                    continue;
                }
                if (simpleIterator == caller) continue;
                simpleIterator.invalidate();
            }
        }
        this.iterators.removeAll(oldReferences);
    }

    public void setCheckConcurrency(boolean bool) {
        this.checkConcurrency = bool;
    }

    @Override
    public ImmutableGraph getImmutableGraph() {
        return new SimpleImmutableGraph(this);
    }

    class SimpleIterator
    implements Iterator<Triple> {
        private Iterator<Triple> listIter;
        private boolean isValid = true;
        private Triple currentNext;

        public SimpleIterator(Iterator<Triple> listIter) {
            this.listIter = listIter;
        }

        @Override
        public boolean hasNext() {
            this.checkValidity();
            return this.listIter.hasNext();
        }

        @Override
        public Triple next() {
            this.checkValidity();
            this.currentNext = this.listIter.next();
            return this.currentNext;
        }

        @Override
        public void remove() {
            this.checkValidity();
            this.listIter.remove();
            SimpleGraph.this.triples.remove(this.currentNext);
            SimpleGraph.this.invalidateIterators(this);
        }

        private void checkValidity() throws ConcurrentModificationException {
            if (SimpleGraph.this.checkConcurrency && !this.isValid) {
                throw new ConcurrentModificationException();
            }
        }

        private void invalidate() {
            this.isValid = false;
        }
    }
}

