/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils.graphmatching;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.Triple;

public class Utils {
    static Set<BlankNode> getBNodes(Collection<Triple> s) {
        HashSet<BlankNode> result = new HashSet<BlankNode>();
        for (Triple triple : s) {
            if (triple.getSubject() instanceof BlankNode) {
                result.add((BlankNode)triple.getSubject());
            }
            if (!(triple.getObject() instanceof BlankNode)) continue;
            result.add((BlankNode)triple.getObject());
        }
        return result;
    }

    static boolean removeGrounded(Collection<Triple> s1, Collection<Triple> s2) {
        Iterator<Triple> triplesIter = s1.iterator();
        while (triplesIter.hasNext()) {
            Triple triple = triplesIter.next();
            if (!Utils.isGrounded(triple)) continue;
            if (!s2.remove(triple)) {
                return false;
            }
            triplesIter.remove();
        }
        for (Triple triple : s2) {
            if (!Utils.isGrounded(triple)) continue;
            return false;
        }
        return true;
    }

    private static boolean isGrounded(Triple triple) {
        if (triple.getSubject() instanceof BlankNode) {
            return false;
        }
        return !(triple.getObject() instanceof BlankNode);
    }
}

