/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils.graphmatching;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.clerezza.commons.rdf.impl.utils.graphmatching.GraphNotIsomorphicException;
import org.apache.clerezza.commons.rdf.impl.utils.graphmatching.Utils;
import org.apache.clerezza.commons.rdf.impl.utils.graphmatching.collections.IntHashMap;
import org.apache.clerezza.commons.rdf.impl.utils.graphmatching.collections.IntIterator;

public class HashMatching {
    private Map<BlankNode, BlankNode> matchings = new HashMap<BlankNode, BlankNode>();
    private Map<Set<BlankNode>, Set<BlankNode>> matchingGroups;

    HashMatching(Graph tc1, Graph tc2) throws GraphNotIsomorphicException {
        int foundMatchings = 0;
        int foundMatchingGroups = 0;
        Map<BlankNode, Integer> bNodeHashMap = new HashMap<BlankNode, Integer>();
        while (true) {
            if ((bNodeHashMap = this.matchByHashes(tc1, tc2, bNodeHashMap)) == null) {
                throw new GraphNotIsomorphicException();
            }
            if (this.matchings.size() == foundMatchings && this.matchingGroups.size() <= foundMatchingGroups) break;
            foundMatchings = this.matchings.size();
            foundMatchingGroups = this.matchingGroups.size();
        }
    }

    public Map<Set<BlankNode>, Set<BlankNode>> getMatchingGroups() {
        return this.matchingGroups;
    }

    public Map<BlankNode, BlankNode> getMatchings() {
        return this.matchings;
    }

    private static IntHashMap<Set<BlankNode>> getHashNodes(Map<BlankNode, Set<Property>> bNodePropMap, Map<BlankNode, Integer> bNodeHashMap) {
        IntHashMap<Set<BlankNode>> result = new IntHashMap<Set<BlankNode>>();
        for (Map.Entry<BlankNode, Set<Property>> entry : bNodePropMap.entrySet()) {
            int hash = HashMatching.computeHash(entry.getValue(), bNodeHashMap);
            Set<BlankNode> bNodeSet = result.get(hash);
            if (bNodeSet == null) {
                bNodeSet = new HashSet<BlankNode>();
                result.put(hash, bNodeSet);
            }
            bNodeSet.add(entry.getKey());
        }
        return result;
    }

    private Map<BlankNode, Integer> matchByHashes(Graph g1, Graph g2, Map<BlankNode, Integer> bNodeHashMap) {
        Map<BlankNode, Set<Property>> bNodePropMap1 = HashMatching.getBNodePropMap(g1);
        Map<BlankNode, Set<Property>> bNodePropMap2 = HashMatching.getBNodePropMap(g2);
        IntHashMap<Set<BlankNode>> hashNodeMap1 = HashMatching.getHashNodes(bNodePropMap1, bNodeHashMap);
        IntHashMap<Set<BlankNode>> hashNodeMap2 = HashMatching.getHashNodes(bNodePropMap2, bNodeHashMap);
        if (!hashNodeMap1.keySet().equals(hashNodeMap2.keySet())) {
            return null;
        }
        this.matchingGroups = new HashMap<Set<BlankNode>, Set<BlankNode>>();
        IntIterator hashIter = hashNodeMap1.keySet().intIterator();
        while (hashIter.hasNext()) {
            int hash = (Integer)hashIter.next();
            Set<BlankNode> nodes1 = hashNodeMap1.get(hash);
            Set<BlankNode> nodes2 = hashNodeMap2.get(hash);
            if (nodes1.size() != nodes2.size()) {
                return null;
            }
            if (nodes1.size() != 1) {
                this.matchingGroups.put(nodes1, nodes2);
                continue;
            }
            BlankNode bNode1 = nodes1.iterator().next();
            BlankNode bNode2 = nodes2.iterator().next();
            this.matchings.put(bNode1, bNode2);
            MappedNode mappedNode = new MappedNode(bNode1, bNode2);
            HashMatching.replaceNode(g1, bNode1, mappedNode);
            HashMatching.replaceNode(g2, bNode2, mappedNode);
            if (Utils.removeGrounded((Collection<Triple>)g1, (Collection<Triple>)g2)) continue;
            return null;
        }
        HashMap<BlankNode, Integer> result = new HashMap<BlankNode, Integer>();
        HashMatching.addInverted(result, hashNodeMap1);
        HashMatching.addInverted(result, hashNodeMap2);
        return result;
    }

    private static int computeHash(Set<Property> propertySet, Map<BlankNode, Integer> bNodeHashMap) {
        int result = 0;
        for (Property property : propertySet) {
            result += property.hashCode(bNodeHashMap);
        }
        return result;
    }

    private static Map<BlankNode, Set<Property>> getBNodePropMap(Graph g) {
        Set<BlankNode> bNodes = Utils.getBNodes((Collection<Triple>)g);
        HashMap<BlankNode, Set<Property>> result = new HashMap<BlankNode, Set<Property>>();
        for (BlankNode bNode : bNodes) {
            result.put(bNode, HashMatching.getProperties(bNode, g));
        }
        return result;
    }

    private static Set<Property> getProperties(BlankNode bNode, Graph g) {
        Triple triple;
        HashSet<Property> result = new HashSet<Property>();
        Iterator ti = g.filter((BlankNodeOrIRI)bNode, null, null);
        while (ti.hasNext()) {
            triple = (Triple)ti.next();
            result.add(new ForwardProperty(triple.getPredicate(), triple.getObject()));
        }
        ti = g.filter(null, null, (RDFTerm)bNode);
        while (ti.hasNext()) {
            triple = (Triple)ti.next();
            result.add(new BackwardProperty(triple.getSubject(), triple.getPredicate()));
        }
        return result;
    }

    private static int nodeHash(RDFTerm resource, Map<BlankNode, Integer> bNodeHashMap) {
        if (resource instanceof BlankNode) {
            Integer mapValue = bNodeHashMap.get((BlankNode)resource);
            if (mapValue == null) {
                return 0;
            }
            return mapValue;
        }
        return resource.hashCode();
    }

    private static void replaceNode(Graph graph, BlankNode bNode, BlankNodeOrIRI replacementNode) {
        HashSet<Triple> triplesToRemove = new HashSet<Triple>();
        for (Triple triple : graph) {
            Triple replacementTriple = HashMatching.getReplacement(triple, bNode, replacementNode);
            if (replacementTriple == null) continue;
            triplesToRemove.add(triple);
            graph.add((Object)replacementTriple);
        }
        graph.removeAll(triplesToRemove);
    }

    private static Triple getReplacement(Triple triple, BlankNode bNode, BlankNodeOrIRI replacementNode) {
        if (triple.getSubject().equals(bNode)) {
            if (triple.getObject().equals(bNode)) {
                return new TripleImpl(replacementNode, triple.getPredicate(), (RDFTerm)replacementNode);
            }
            return new TripleImpl(replacementNode, triple.getPredicate(), triple.getObject());
        }
        if (triple.getObject().equals(bNode)) {
            return new TripleImpl(triple.getSubject(), triple.getPredicate(), (RDFTerm)replacementNode);
        }
        return null;
    }

    private static void addInverted(Map<BlankNode, Integer> result, IntHashMap<Set<BlankNode>> hashNodeMap) {
        Iterator iterator = hashNodeMap.keySet().iterator();
        while (iterator.hasNext()) {
            int hash = (Integer)iterator.next();
            Set<BlankNode> bNodes = hashNodeMap.get(hash);
            for (BlankNode bNode : bNodes) {
                result.put(bNode, hash);
            }
        }
    }

    private static interface Property {
        public int hashCode(Map<BlankNode, Integer> var1);
    }

    private static class MappedNode
    implements BlankNodeOrIRI {
        private BlankNode bNode1;
        private BlankNode bNode2;

        public MappedNode(BlankNode bNode1, BlankNode bNode2) {
            this.bNode1 = bNode1;
            this.bNode2 = bNode2;
        }
    }

    private static class ForwardProperty
    implements Property {
        private IRI predicate;
        private RDFTerm object;

        public ForwardProperty(IRI predicate, RDFTerm object) {
            this.predicate = predicate;
            this.object = object;
        }

        @Override
        public int hashCode(Map<BlankNode, Integer> bNodeHashMap) {
            return this.predicate.hashCode() ^ HashMatching.nodeHash(this.object, bNodeHashMap);
        }
    }

    private static class BackwardProperty
    implements Property {
        private BlankNodeOrIRI subject;
        private IRI predicate;

        public BackwardProperty(BlankNodeOrIRI subject, IRI predicate) {
            this.subject = subject;
            this.predicate = predicate;
        }

        @Override
        public int hashCode(Map<BlankNode, Integer> bNodeHashMap) {
            return 0xFF ^ this.predicate.hashCode() ^ HashMatching.nodeHash((RDFTerm)this.subject, bNodeHashMap);
        }
    }
}

