/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils.graphmatching;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.clerezza.commons.rdf.impl.utils.graphmatching.GraphNotIsomorphicException;
import org.apache.clerezza.commons.rdf.impl.utils.graphmatching.GroupMappingIterator;
import org.apache.clerezza.commons.rdf.impl.utils.graphmatching.HashMatching;
import org.apache.clerezza.commons.rdf.impl.utils.graphmatching.Utils;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleMGraph;

public class GraphMatcher {
    private static final Logger log = Logger.getLogger(GraphMatcher.class.getName());

    public static Map<BlankNode, BlankNode> getValidMapping(Graph og1, Graph og2) {
        HashMatching hashMatching;
        SimpleMGraph g1 = new SimpleMGraph((Collection<Triple>)og1);
        SimpleMGraph g2 = new SimpleMGraph((Collection<Triple>)og2);
        if (!Utils.removeGrounded(g1, g2)) {
            return null;
        }
        try {
            hashMatching = new HashMatching(g1, g2);
        }
        catch (GraphNotIsomorphicException ex) {
            return null;
        }
        Map<BlankNode, BlankNode> matchings = hashMatching.getMatchings();
        if (g1.size() > 0) {
            Map<BlankNode, BlankNode> remainingMappings = GraphMatcher.trialAndErrorMatching(g1, g2, hashMatching.getMatchingGroups());
            if (remainingMappings == null) {
                return null;
            }
            matchings.putAll(remainingMappings);
        }
        return matchings;
    }

    private static Map<BlankNode, BlankNode> trialAndErrorMatching(Graph g1, Graph g2, Map<Set<BlankNode>, Set<BlankNode>> matchingGroups) {
        if (log.isLoggable(Level.FINE)) {
            Set<BlankNode> bn1 = Utils.getBNodes((Collection<Triple>)g1);
            log.log(Level.FINE, "doing trial and error matching for {0} bnodes, in graphs of size: {1}.", new Object[]{bn1.size(), g1.size()});
        }
        Iterator mappingIter = GroupMappingIterator.create(matchingGroups);
        while (mappingIter.hasNext()) {
            Map<BlankNode, BlankNode> map = mappingIter.next();
            if (!GraphMatcher.checkMapping(g1, g2, map)) continue;
            return map;
        }
        return null;
    }

    private static boolean checkMapping(Graph g1, Graph g2, Map<BlankNode, BlankNode> map) {
        for (Triple triple : g1) {
            if (g2.contains((Object)GraphMatcher.map(triple, map))) continue;
            return false;
        }
        return true;
    }

    private static Triple map(Triple triple, Map<BlankNode, BlankNode> map) {
        BlankNodeOrIRI oSubject = triple.getSubject();
        BlankNodeOrIRI subject = oSubject instanceof BlankNode ? (BlankNodeOrIRI)map.get((BlankNode)oSubject) : oSubject;
        RDFTerm oObject = triple.getObject();
        RDFTerm object = oObject instanceof BlankNode ? (RDFTerm)map.get((BlankNode)oObject) : oObject;
        return new TripleImpl(subject, triple.getPredicate(), object);
    }
}

