/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.ImmutableGraph;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;
import org.apache.clerezza.commons.rdf.WatchableGraph;
import org.apache.clerezza.commons.rdf.event.AddEvent;
import org.apache.clerezza.commons.rdf.event.FilterTriple;
import org.apache.clerezza.commons.rdf.event.GraphEvent;
import org.apache.clerezza.commons.rdf.event.GraphListener;
import org.apache.clerezza.commons.rdf.event.RemoveEvent;
import org.apache.clerezza.commons.rdf.impl.utils.DelayedNotificator;

public class WatchableGraphWrapper
implements WatchableGraph {
    final Graph wrapped;
    private final Set<ListenerConfiguration> listenerConfigs = Collections.synchronizedSet(new HashSet());
    private DelayedNotificator delayedNotificator = new DelayedNotificator();

    public WatchableGraphWrapper(Graph wrapped) {
        this.wrapped = wrapped;
    }

    public Iterator<Triple> iterator() {
        return this.filter(null, null, null);
    }

    public boolean contains(Object o) {
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple t = (Triple)o;
        return this.filter(t.getSubject(), t.getPredicate(), t.getObject()).hasNext();
    }

    public Iterator<Triple> filter(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        final Iterator baseIter = this.wrapped.filter(subject, predicate, object);
        return new Iterator<Triple>(){
            Triple currentTriple = null;

            @Override
            public boolean hasNext() {
                return baseIter.hasNext();
            }

            @Override
            public Triple next() {
                this.currentTriple = (Triple)baseIter.next();
                return this.currentTriple;
            }

            @Override
            public void remove() {
                baseIter.remove();
                WatchableGraphWrapper.this.dispatchEvent((GraphEvent)new RemoveEvent((Graph)WatchableGraphWrapper.this, this.currentTriple));
            }
        };
    }

    public boolean add(Triple triple) {
        boolean success = this.performAdd(triple);
        if (success) {
            this.dispatchEvent((GraphEvent)new AddEvent((Graph)this, triple));
        }
        return success;
    }

    protected boolean performAdd(Triple e) {
        return this.wrapped.add((Object)e);
    }

    public boolean remove(Object o) {
        Triple triple = (Triple)o;
        boolean success = this.performRemove(triple);
        if (success) {
            this.dispatchEvent((GraphEvent)new RemoveEvent((Graph)this, triple));
        }
        return success;
    }

    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object object : c) {
            if (!this.remove(object)) continue;
            modified = true;
        }
        return modified;
    }

    protected boolean performRemove(Triple triple) {
        Iterator<Triple> e = this.filter(null, null, null);
        while (e.hasNext()) {
            if (!triple.equals((Object)e.next())) continue;
            e.remove();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(GraphEvent event) {
        Set<ListenerConfiguration> set = this.listenerConfigs;
        synchronized (set) {
            Iterator<ListenerConfiguration> iter = this.listenerConfigs.iterator();
            while (iter.hasNext()) {
                ListenerConfiguration config = iter.next();
                GraphListener registeredListener = config.getListener();
                if (registeredListener == null) {
                    iter.remove();
                    continue;
                }
                if (!config.getFilter().match(event.getTriple())) continue;
                this.delayedNotificator.sendEventToListener(registeredListener, event);
            }
        }
    }

    public void addGraphListener(GraphListener listener, FilterTriple filter) {
        this.addGraphListener(listener, filter, 0L);
    }

    public void addGraphListener(GraphListener listener, FilterTriple filter, long delay) {
        this.listenerConfigs.add(new ListenerConfiguration(listener, filter));
        if (delay > 0L) {
            this.delayedNotificator.addDelayedListener(listener, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGraphListener(GraphListener listener) {
        Set<ListenerConfiguration> set = this.listenerConfigs;
        synchronized (set) {
            Iterator<ListenerConfiguration> iter = this.listenerConfigs.iterator();
            while (iter.hasNext()) {
                ListenerConfiguration listenerConfig = iter.next();
                GraphListener registeredListener = listenerConfig.getListener();
                if (registeredListener != null && !registeredListener.equals(listener)) continue;
                iter.remove();
            }
        }
        this.delayedNotificator.removeDelayedListener(listener);
    }

    public ImmutableGraph getImmutableGraph() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ReadWriteLock getLock() {
        return this.wrapped.getLock();
    }

    public int size() {
        return this.wrapped.size();
    }

    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    public Object[] toArray() {
        return this.wrapped.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.wrapped.toArray((Object[])a);
    }

    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    public boolean addAll(Collection<? extends Triple> c) {
        return this.wrapped.addAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.wrapped.retainAll(c);
    }

    public void clear() {
        this.wrapped.clear();
    }

    private static class ListenerConfiguration {
        private WeakReference<GraphListener> listenerRef;
        private FilterTriple filter;

        private ListenerConfiguration(GraphListener listener, FilterTriple filter) {
            this.listenerRef = new WeakReference<GraphListener>(listener);
            this.filter = filter;
        }

        GraphListener getListener() {
            GraphListener listener = (GraphListener)this.listenerRef.get();
            return listener;
        }

        FilterTriple getFilter() {
            return this.filter;
        }
    }
}

