/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils;

import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.Triple;

public class TripleImpl
implements Triple {
    private final BlankNodeOrIRI subject;
    private final IRI predicate;
    private final RDFTerm object;

    public TripleImpl(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        if (subject == null) {
            throw new IllegalArgumentException("Invalid subject: null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Invalid predicate: null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Invalid object: null");
        }
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)obj;
        if (!this.subject.equals(other.getSubject())) {
            return false;
        }
        if (!this.predicate.equals((Object)other.getPredicate())) {
            return false;
        }
        return this.object.equals(other.getObject());
    }

    public int hashCode() {
        return this.subject.hashCode() >> 1 ^ this.predicate.hashCode() ^ this.object.hashCode() << 1;
    }

    public BlankNodeOrIRI getSubject() {
        return this.subject;
    }

    public IRI getPredicate() {
        return this.predicate;
    }

    public RDFTerm getObject() {
        return this.object;
    }

    public String toString() {
        return this.subject + " " + this.predicate + " " + this.object + ".";
    }
}

