/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils;

import java.io.Serializable;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Language;
import org.apache.clerezza.commons.rdf.Literal;
import org.apache.clerezza.commons.rdf.impl.utils.AbstractLiteral;

public class PlainLiteralImpl
extends AbstractLiteral
implements Literal,
Serializable {
    private final String lexicalForm;
    private final Language language;
    private final IRI dataType;
    private static final IRI XSD_STRING = new IRI("http://www.w3.org/2001/XMLSchema#string");
    private static final IRI RDF_LANG_STRING = new IRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#langString");

    public PlainLiteralImpl(String value) {
        this(value, null);
    }

    public PlainLiteralImpl(String value, Language language) {
        if (value == null) {
            throw new IllegalArgumentException("The literal string cannot be null");
        }
        this.lexicalForm = value;
        this.language = language;
        this.dataType = language == null ? XSD_STRING : RDF_LANG_STRING;
    }

    public String getLexicalForm() {
        return this.lexicalForm;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('\"').append(this.lexicalForm).append('\"');
        if (this.language != null) {
            result.append("@").append(this.language.toString());
        }
        return result.toString();
    }

    public IRI getDataType() {
        return this.dataType;
    }
}

