/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.clerezza.commons.rdf.Triple;

class LockingIterator
implements Iterator<Triple> {
    private Iterator<Triple> base;
    private Lock readLock;
    private Lock writeLock;

    public LockingIterator(Iterator<Triple> iterator, ReadWriteLock lock) {
        this.base = iterator;
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public boolean hasNext() {
        this.readLock.lock();
        try {
            boolean bl = this.base.hasNext();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Triple next() {
        this.readLock.lock();
        try {
            Triple triple = this.base.next();
            return triple;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void remove() {
        this.writeLock.lock();
        try {
            this.base.remove();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

