/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.commons.rdf.impl.utils;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.clerezza.commons.rdf.event.GraphEvent;
import org.apache.clerezza.commons.rdf.event.GraphListener;

class DelayedNotificator {
    private static final Logger log = Logger.getLogger(DelayedNotificator.class.getName());
    private static Timer timer = new Timer("Event delivery timer", true);
    private final Map<GraphListener, ListenerHolder> map = Collections.synchronizedMap(new WeakHashMap());

    DelayedNotificator() {
    }

    void addDelayedListener(GraphListener listener, long delay) {
        this.map.put(listener, new ListenerHolder(listener, delay));
    }

    void removeDelayedListener(GraphListener listener) {
        this.map.remove(listener);
    }

    void sendEventToListener(GraphListener listener, GraphEvent event) {
        ListenerHolder holder = this.map.get(listener);
        if (holder == null) {
            listener.graphChanged(Collections.singletonList(event));
        } else {
            holder.registerEvent(event);
        }
    }

    static class ListenerHolder {
        long delay;
        List<GraphEvent> events = null;
        WeakReference<GraphListener> listenerRef;

        public ListenerHolder(GraphListener listener, long delay) {
            this.listenerRef = new WeakReference<GraphListener>(listener);
            this.delay = delay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerEvent(GraphEvent event) {
            ListenerHolder listenerHolder = this;
            synchronized (listenerHolder) {
                if (this.events == null) {
                    this.events = new ArrayList<GraphEvent>();
                    this.events.add(event);
                    timer.schedule(new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<GraphEvent> eventsLocal;
                            ListenerHolder listenerHolder = this;
                            synchronized (listenerHolder) {
                                eventsLocal = events;
                                events = null;
                            }
                            GraphListener listener = (GraphListener)listenerRef.get();
                            if (listener == null) {
                                log.fine("Ignoring garbage collected listener");
                            } else {
                                try {
                                    listener.graphChanged(eventsLocal);
                                }
                                catch (Exception e) {
                                    log.log(Level.WARNING, "Exception delivering ImmutableGraph event", e);
                                }
                            }
                        }
                    }, this.delay);
                } else {
                    this.events.add(event);
                }
            }
        }
    }
}

